package com.tykj.workflowcore;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.workflow_editer.controller.FlowsInfoController;
import com.tykj.workflowcore.workflow_editer.controller.WorkFlowController;
import org.aspectj.lang.annotation.Before;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import springfox.documentation.spring.web.json.Json;

import static org.hamcrest.Matchers.equalToObject;
import static org.hamcrest.Matchers.not;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureMockMvc
class WorkflowCoreApplicationTests_workflow {

    @Autowired
    private FlowsInfoController flowsInfoController;

    @Autowired
    private WorkFlowController workFlowController;
    @Autowired
    MockMvc mockMvc;

    RequestBuilder request;

    @Before("")
    public void setUp() {
        mockMvc = MockMvcBuilders.standaloneSetup(flowsInfoController).build();
        mockMvc = MockMvcBuilders.standaloneSetup(workFlowController).build();
    }

    @Test
    //部署流程
    void deployFlow() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bpmn2=\"http://www" +
                ".omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" " +
                "xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:di=\"http://www.omg" +
                ".org/spec/DD/20100524/DI\" targetNamespace=\"http://bpmn.io/schema/bpmn\">\n" +
                "  <bpmn2:process id=\"processId_26246e2b-2f1a-46a5-b2f1-f3df8109d06b\" name=\"processName_1\" " +
                "isExecutable=\"true\">\n" +
                "    <bpmn2:documentation>description_1</bpmn2:documentation>\n" +
                "    <bpmn2:startEvent id=\"StartEvent_30cf7590-b7a4-4b17-ab9b-e1d1af577c77\" name=\"1\">\n" +
                "      <bpmn2:outgoing>Flow_0mknr4h</bpmn2:outgoing>\n" +
                "    </bpmn2:startEvent>\n" +
                "    <bpmn2:endEvent id=\"Event_1790b5c6-cb47-4193-8ffa-c721812850cf\" name=\"4\">\n" +
                "      <bpmn2:incoming>Flow_01cdmlh</bpmn2:incoming>\n" +
                "    </bpmn2:endEvent>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_01cdmlh\" " +
                "sourceRef=\"Activity_305965ea-f523-4891-a0e1-9024412c83b3\" " +
                "targetRef=\"Event_1790b5c6-cb47-4193-8ffa-c721812850cf\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_0mknr4h\" " +
                "sourceRef=\"StartEvent_30cf7590-b7a4-4b17-ab9b-e1d1af577c77\" " +
                "targetRef=\"Activity_9ce9cc86-6a7d-48a7-833d-72a1bcb526b1\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_0is5s56\" " +
                "sourceRef=\"Activity_9ce9cc86-6a7d-48a7-833d-72a1bcb526b1\" " +
                "targetRef=\"Activity_305965ea-f523-4891-a0e1-9024412c83b3\" />\n" +
                "    <bpmn2:userTask id=\"Activity_9ce9cc86-6a7d-48a7-833d-72a1bcb526b1\" name=\"2\">\n" +
                "      <bpmn2:incoming>Flow_0mknr4h</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_0is5s56</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "    <bpmn2:userTask id=\"Activity_305965ea-f523-4891-a0e1-9024412c83b3\" name=\"3\">\n" +
                "      <bpmn2:incoming>Flow_0is5s56</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_01cdmlh</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "  </bpmn2:process>\n" +
                "  <bpmndi:BPMNDiagram id=\"BPMNDiagram_1\">\n" +
                "    <bpmndi:BPMNPlane id=\"BPMNPlane_1\" " +
                "bpmnElement=\"processId_8b17c25a-db3c-4392-bc3c-c4d3e6af8ba8\">\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_01cdmlh_di\" bpmnElement=\"Flow_01cdmlh\">\n" +
                "        <di:waypoint x=\"510\" y=\"178\" />\n" +
                "        <di:waypoint x=\"562\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_0mknr4h_di\" bpmnElement=\"Flow_0mknr4h\">\n" +
                "        <di:waypoint x=\"196\" y=\"178\" />\n" +
                "        <di:waypoint x=\"250\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_0is5s56_di\" bpmnElement=\"Flow_0is5s56\">\n" +
                "        <di:waypoint x=\"350\" y=\"178\" />\n" +
                "        <di:waypoint x=\"410\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNShape id=\"_BPMNShape_StartEvent_2\" " +
                "bpmnElement=\"StartEvent_30cf7590-b7a4-4b17-ab9b-e1d1af577c77\">\n" +
                "        <dc:Bounds x=\"160\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "        <bpmndi:BPMNLabel>\n" +
                "          <dc:Bounds x=\"175\" y=\"203\" width=\"7\" height=\"14\" />\n" +
                "        </bpmndi:BPMNLabel>\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Event_0blwxcq_di\" " +
                "bpmnElement=\"Event_1790b5c6-cb47-4193-8ffa-c721812850cf\">\n" +
                "        <dc:Bounds x=\"562\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "        <bpmndi:BPMNLabel>\n" +
                "          <dc:Bounds x=\"577\" y=\"203\" width=\"7\" height=\"14\" />\n" +
                "        </bpmndi:BPMNLabel>\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_05096b4_di\" " +
                "bpmnElement=\"Activity_9ce9cc86-6a7d-48a7-833d-72a1bcb526b1\">\n" +
                "        <dc:Bounds x=\"250\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_1iwz5sx_di\" " +
                "bpmnElement=\"Activity_305965ea-f523-4891-a0e1-9024412c83b3\">\n" +
                "        <dc:Bounds x=\"410\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\" xmlns:flowable=\"http://flowable.org/bpmn\" targetNamespace=\"http://bpmn.io/schema/bpmn\">\n" +
                "  <bpmn2:process id=\"processId_26246e2b-2f1a-46a5-b2f1-f3df8109d06b\" name=\"测试流程1\" isExecutable=\"true\">\n" +
                "    <bpmn2:documentation>这是一个测试流程1</bpmn2:documentation>\n" +
                "    <bpmn2:startEvent id=\"StartEvent_38617d3f-09e7-4342-aa7a-49e89189d4d2\">\n" +
                "      <bpmn2:outgoing>Flow_1jxsm3b</bpmn2:outgoing>\n" +
                "    </bpmn2:startEvent>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_1jxsm3b\" sourceRef=\"StartEvent_38617d3f-09e7-4342-aa7a-49e89189d4d2\" targetRef=\"Activity_b4c5faae-2078-4c24-8e8c-d8fae56c2136\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_1xfelj7\" sourceRef=\"Activity_b4c5faae-2078-4c24-8e8c-d8fae56c2136\" targetRef=\"Activity_32aa4df7-1f13-439d-a3f9-58c3d01ef9f9\" />\n" +
                "    <bpmn2:userTask id=\"Activity_b4c5faae-2078-4c24-8e8c-d8fae56c2136\" name=\"人工节点1\" flowable:assignee=\"zhangsan\">\n" +
                "      <bpmn2:incoming>Flow_1jxsm3b</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_1xfelj7</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "    <bpmn2:userTask id=\"Activity_32aa4df7-1f13-439d-a3f9-58c3d01ef9f9\" name=\"人工节点2\" flowable:assignee=\"lisi\">\n" +
                "      <bpmn2:incoming>Flow_1xfelj7</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_0n5k9bw</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "    <bpmn2:endEvent id=\"Event_5835a2ee-d2ae-43c5-9d4a-7d8c9dff0dea\">\n" +
                "      <bpmn2:incoming>Flow_0n5k9bw</bpmn2:incoming>\n" +
                "    </bpmn2:endEvent>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_0n5k9bw\" sourceRef=\"Activity_32aa4df7-1f13-439d-a3f9-58c3d01ef9f9\" targetRef=\"Event_5835a2ee-d2ae-43c5-9d4a-7d8c9dff0dea\" />\n" +
                "  </bpmn2:process>\n" +
                "  <bpmndi:BPMNDiagram id=\"BPMNDiagram_1\">\n" +
                "    <bpmndi:BPMNPlane id=\"BPMNPlane_1\" bpmnElement=\"processId_26246e2b-2f1a-46a5-b2f1-f3df8109d06b\">\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_1jxsm3b_di\" bpmnElement=\"Flow_1jxsm3b\">\n" +
                "        <di:waypoint x=\"196\" y=\"178\" />\n" +
                "        <di:waypoint x=\"250\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_1xfelj7_di\" bpmnElement=\"Flow_1xfelj7\">\n" +
                "        <di:waypoint x=\"350\" y=\"178\" />\n" +
                "        <di:waypoint x=\"410\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_0n5k9bw_di\" bpmnElement=\"Flow_0n5k9bw\">\n" +
                "        <di:waypoint x=\"510\" y=\"178\" />\n" +
                "        <di:waypoint x=\"572\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNShape id=\"_BPMNShape_StartEvent_2\" bpmnElement=\"StartEvent_38617d3f-09e7-4342-aa7a-49e89189d4d2\">\n" +
                "        <dc:Bounds x=\"160\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_051mk34_di\" bpmnElement=\"Activity_b4c5faae-2078-4c24-8e8c-d8fae56c2136\">\n" +
                "        <dc:Bounds x=\"250\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_0audtcs_di\" bpmnElement=\"Activity_32aa4df7-1f13-439d-a3f9-58c3d01ef9f9\">\n" +
                "        <dc:Bounds x=\"410\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Event_181nibi_di\" bpmnElement=\"Event_5835a2ee-d2ae-43c5-9d4a-7d8c9dff0dea\">\n" +
                "        <dc:Bounds x=\"572\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "    </bpmndi:BPMNPlane>\n" +
                "  </bpmndi:BPMNDiagram>\n" +
                "</bpmn2:definitions>\n";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileXml",xml);
        jsonObject.put("flowKey","processId_26246e2b-2f1a-46a5-b2f1-f3df8109d06b");
        jsonObject.put("flowName","测试流程1");

        request = post("/flowsInfo/saveXml/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("fileXml",xml)//参数
//                .param("flowKey","processId_df8ce31c-c23c-4e5d-8401-e4e99286dba8")//参数
//                .param("flowName","processName_2")
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test
        //开启流程
    void startFlow() throws Exception {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowKey","processId_26246e2b-2f1a-46a5-b2f1-f3df8109d06b");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("handlingOpinion","0");

        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("id","5");
        jsonObject2.put("userName","张三");

        jsonObject1.put("workFlowUser",jsonObject2);
        jsonObject.put("map",jsonObject1);
        request = post("/workFlow/startFlow/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("fileXml",xml)//参数
//                .param("flowKey","processId_df8ce31c-c23c-4e5d-8401-e4e99286dba8")//参数
//                .param("flowName","processName_2")
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }
    @Test
        //查询代办
        //开启流程
    void findUserTask() throws Exception {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userId","zhangsan");
        request = post("/workFlow/findUserTask/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("userId","zhangsan")//参数
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test
        //查询代办
    void findUserTaskDetail() throws Exception {

//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("taskId","2563cd2d-8c72-11eb-9463-005056c00001");
        request = get("/workFlow/findTaskDetail/")
                .contentType(MediaType.APPLICATION_JSON)
                .param("taskId","2563cd2d-8c72-11eb-9463-005056c00001")//参数
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

}
