package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.xml.stream.XMLStreamException;
import java.io.FileNotFoundException;
import java.io.IOException;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api(tags = "流程管理接口")
@RequestMapping("/flowsInfo")
public class FlowsInfoController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;

    @Autowired
    private NodeInfoService nodeInfoService;

    @Autowired
    private VariableStorageService variableStorageService;


    @PostMapping("/searchAllFlowInfo")
    @ApiOperation(value = "查询所有流程信息")
    public Page<FlowsInfo> searchAllFlowInfo(@RequestBody SearchAllFlowInfoVo searchAllFlowInfoVo){

        return flowInfoService.searchAllFlowInfo(searchAllFlowInfoVo);
    }

    @PostMapping("/searchFlowInfo")
    @ApiOperation(value = "查询可发起流程信息")
    public Page<FlowsInfo> searchFlowInfo(@RequestBody SearchFlowInfoVo searchFlowInfoVo){

        return flowInfoService.searchFlowInfo(searchFlowInfoVo);
    }

    @PostMapping("/upLoadFile")
    @ApiOperation(value = "上传文件")
    public String upLoadFile(@RequestParam("file") MultipartFile file){
        return  workFlowService.upLoadFile(file);
    }

    @GetMapping("editFlow")
    @ApiOperation(value = "编辑流程")
    public ResponseEntity editFlow(Integer id){
            return  ResultUtil.success(flowInfoService.editFlow(id),"查询成功");
    }



    @PostMapping("/saveXml")
    @ApiOperation(value = "保存xml以及其他流程信息")
    public ResponseEntity saveXml(@RequestBody FlowsInfoVo flowsInfoVo) throws IOException, XMLStreamException {
        //保存节点信息
        nodeInfoService.saveNodeInfoList(flowsInfoVo.getNodeInfoList());
        //保存xml信息
        workFlowService.flowXml(flowsInfoVo);
        return ResultUtil.success("文件保存成功");
    }

    @PostMapping("/updateByProcessName")
    @ApiOperation(value = "通过流程名称修改")
    public ResponseEntity updateByProcessName(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByFlowName(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowName(),"流程修改成功");
    }

    @PostMapping("/updateByDesc")
    @ApiOperation(value = "通过流程描述修改")
    public ResponseEntity updateByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByDesc(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowDescribe(),"流程修改成功");
    }

    @PostMapping("/createFlow")
    @ApiModelProperty("创建流程")
    public ResponseEntity createFlow(@RequestBody FlowsInfoVo flowsInfovo){
        return ResultUtil.success(workFlowService.createFlow(flowsInfovo.toEntity()),"流程创建成功");
    }

    @PostMapping("/saveVariableStorage")
    @ApiModelProperty("保存函数调用配置")
    public ResponseEntity saveVariableStorage(@RequestBody VariableStorageVo variableStorageVo){
        VariableStorage variableStorage = variableStorageService.saveVariableStorageService(variableStorageVo.toEntity());
        return ResultUtil.success(variableStorage,"保存接口调用配置成功");
    }

    @PostMapping("/searchVariableStorage")
    @ApiModelProperty("查找函数调用配置")
    public ResponseEntity searchVariableStorage(@RequestBody SearchVariableStorageVo searchVariableStorageVo){
        return ResultUtil.success( variableStorageService.searchVariableStoragePage(searchVariableStorageVo),"查询接口调用配置成功");
    }

}
