package com.tykj.workflowcore.model_layer.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("字段信息（聚合对象用）")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ColumnEXVO {

    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("是否主键")
    private Integer primaryKey;
    @ApiModelProperty("字段类型")
    private String fieldType;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("中文描述")
    private String fieldTitle;
    @ApiModelProperty("字段长度，有默认值")
    private Integer fieldLength;
    @ApiModelProperty("详细描述")
    private String description;
    @ApiModelProperty("聚合类型: -1无 0一对一 1一对多 2多对多")
    private Integer aggregationType;
    @ApiModelProperty("如果类型是个对象 该对象下的字段信息")
    private List<ColumnEXVO> columns;

}
