package com.tykj.workflowcore.base.aop;

import com.tykj.workflowcore.base.entity.BaseEntity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

import java.util.Date;

import static java.util.Objects.isNull;

/**
 * @author C
 */
@Aspect
@Component
public class EntityHandle {

    @Before("execution(* org.springframework.data.repository.CrudRepository.save(..)) && args(com.tykj.workflowcore.base.entity.BaseEntity))")
    public void checkTimes(JoinPoint point) {
        Object[] args = point.getArgs();
        for (Object arg : args) {
            if (arg instanceof BaseEntity){
                BaseEntity entity = (BaseEntity) arg;
                if (isNull(entity.getCreatedTime())){
                    entity.setCreatedTime(new Date());
                }
                entity.setUpdatedTime(new Date());
            }
        }
    }


}
