package com.tykj.workflowcore.model_layer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.model_layer.dao.AggregationDao;
import com.tykj.workflowcore.model_layer.entity.Aggregation;
import com.tykj.workflowcore.model_layer.entity.vo.AggregationVO;
import com.tykj.workflowcore.model_layer.service.AggregationService;
import com.tykj.workflowcore.model_layer.service.impl.ModelHelper;
import io.swagger.annotations.Api;
import liquibase.pro.packaged.A;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

/**
 * @ClassName AggregationController
 * @Description TODO
 * @Author WWW
 * @Date 2021/4/2 11:19
 * @Version 1.0
 */
@Api(tags = "聚合对象")
@RestController
@RequestMapping("/aggregation")
public class AggregationController {

    @Autowired
    AggregationService aggregationService;

    @Autowired
    AggregationDao aggregationDao;
    @Autowired
    ModelHelper modelHelper;

    @PostMapping("/add")
    public ResponseEntity add(@RequestBody AggregationVO aggregationVO) {
        aggregationService.addAggregation(aggregationVO);
        return ResultUtil.success("","保存成功！");
    }

    @PostMapping("/findTest")
    public ResponseEntity findTest(Integer id) {

        return ResultUtil.success(aggregationDao.findAllByTableInfoExIdAndParentId(id,null),"保存成功！");
    }

    @PostMapping("/test")
    public ResponseEntity test(@RequestBody AggregationVO AggregationVO) {
        String result= "";
        Document document = DocumentHelper.createDocument();
        Element rootElement = DocumentHelper.createElement("rootElement");
        String s = testDG(AggregationVO.getAggregations(), null, 1, rootElement).asXML();
        document.add(rootElement);
        return ResultUtil.success(aggregationDao.findById(3),"保存成功！");
    }

    //假设获得的是一份XML
    public Element testDG(List<Aggregation> aggregations, Aggregation parentAggregation, Integer mainId, Element element){
        //循环
        Element elementCLass = DocumentHelper.createElement("class");
        if (parentAggregation!=null){
            elementCLass.addAttribute("name",parentAggregation.getSideTableId()+"_");
        }else {
            elementCLass.addAttribute("name",mainId+"_");
        }
        for (int i = 0; i < aggregations.size(); i++) {
            Aggregation aggregationChild = aggregations.get(i);
            if (aggregationChild.getAggregations()!=null&&aggregationChild.getAggregations().size()>0){
                Element elementClassChild = testDG(aggregationChild.getAggregations(), aggregationChild, mainId, element);
                Element elementSet = DocumentHelper.createElement("set");
                elementSet.addAttribute("setName","c"+elementClassChild.attribute("name").getValue());
                elementCLass.add(elementSet);
            }else {
                Element elementSet = DocumentHelper.createElement("set");
                elementSet.addAttribute("setName","c"+aggregationChild.getSideTableId());
                elementCLass.add(elementSet);
            }
        }
        element.add(elementCLass);
        return elementCLass;
    }





}
