package com.tykj.workflowcore.model_layer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.List;

/**
 * @ClassName AggregationRelationship
 * @Description TODO
 * @Author WWW
 * @Date 2021/4/2 9:49
 * @Version 1.0
 */
@Accessors(chain = true)
@WorkFlowCoreNoScan
@Data
@Table(name = "aggregation")
@NoArgsConstructor
@AllArgsConstructor
@Entity
@SQLDelete(sql = "update aggregation set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class Aggregation extends BaseEntity {

    @ApiModelProperty("聚合对象ID")
    private Integer tableInfoExId;

    @ApiModelProperty("副表id")
    private Integer sideTableId;

    @ApiModelProperty("聚合对象关系")
    private Integer relationship;

    @ApiModelProperty("主表连接属性")
    private String mainTableConnectionKey;

    @ApiModelProperty("副表连接属性")
    private String sideTableConnectionKey;

    @ApiModelProperty("中间表名称")
    private String connectionTableName;

    @ApiModelProperty("多层嵌套时会生成虚拟对象class 该class为了不影响其他真实对象所以用uuid命名")
    private String uuidTableName;

    private Integer parentId;

    //级联配置
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @JoinColumn(name = "parentId")
    List<Aggregation> aggregations;
}
