package com.tykj.workflowcore.model_layer.entity.vo;


import com.tykj.workflowcore.model_layer.entity.Aggregation;

import com.tykj.workflowcore.model_layer.entity.TableInfo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * @ClassName AggregationVO
 * @Description TODO
 * @Author WWW
 * @Date 2021/4/2 9:51
 * @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@ApiModel("聚合信息")
@Data
public class AggregationVO {

    @ApiModelProperty("名称")
    private String modelName;

    @ApiModelProperty("描述")
    private String modelTitle;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("主表id")
    private Integer mainTableId;

    @ApiModelProperty("关系集合")
   private List<Aggregation> aggregations;

   public TableInfo getTableInfo(){
       TableInfo tableInfo= new TableInfo();
       BeanUtils.copyProperties(this,tableInfo);
       return  tableInfo;
   }
}
