package com.tykj.workflowcore.model_layer.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.model_layer.dao.AggregationDao;
import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoExDao;
import com.tykj.workflowcore.model_layer.entity.Aggregation;
import com.tykj.workflowcore.model_layer.entity.ColumnInfo;
import com.tykj.workflowcore.model_layer.entity.TableInfoEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.lang.String.format;

/**
 * @author C
 */
@Service
public class ModelHelper {

    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private ColumnInfoDao columnInfoDao;
    @Autowired
    private TableInfoExDao tableInfoExDao;
    @Autowired
    private AggregationDao aggregationDao;

    /**
     * 获取指定数据模型的json格式数据示例
     *
     * @param tableInfoId 指定id
     * @return json格式的数据示例
     */
    public String getJsonExpample(Integer tableInfoId) {
        Map<String, Object> result = new HashMap<>();
        //根据表id查出字段信息 并加入Map结果
        List<ColumnInfo> columnInfos = columnInfoDao.findAllByDbId(tableInfoId);
        for (ColumnInfo columnInfo : columnInfos) {
            result.put(columnInfo.getFieldName(), null);
        }
        //做json转换并返回
        try {
            return new ObjectMapper().writeValueAsString(result);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ApiException("json转换时出现异常");
        }
    }

    /**
     * 获取指定聚合对象模型的json格式数据示例
     *
     * @param tableInfoExId 指定id
     * @return json格式的数据示例
     */
    public String getExJsonExample(Integer tableInfoExId) {
        Map<String, Object> result = new HashMap<>();
        TableInfoEx tableInfoEX = tableInfoExDao.findById(tableInfoExId)
                .orElseThrow(() -> new ApiException(format("未找到该id的数据:%s", tableInfoExId)));
        //根据主表id查出主表部分字段信息 并加入Map结果
        List<ColumnInfo> columnInfos = columnInfoDao.findAllByDbId(tableInfoEX.getMainTableId());
        for (ColumnInfo columnInfo : columnInfos) {
            result.put(columnInfo.getFieldName(), null);
        }
        //查出相关聚合信息并做处理
        List<Aggregation> aggregations = aggregationDao.findAllByTableInfoExId(tableInfoExId);
        for (Aggregation aggregation : aggregations) {
            List<ColumnInfo> subColumnInfos = columnInfoDao.findAllByDbId(aggregation.getSideTableId());
            Map<String, Object> subResult = new HashMap<>();
            for (ColumnInfo subColumnInfo : subColumnInfos) {
                subResult.put(subColumnInfo.getFieldName(), null);
            }
            String subTableName = tableInfoDao.findById(aggregation.getSideTableId())
                    .orElseThrow(() -> new RuntimeException(format("未找到该id的数据:%s", aggregation.getSideTableId())))
                    .getModelName();
            //判断关联类型 根据关联类型做不同处理 0:一对一 1:一对多 2:多对多
            Integer relationshipType = aggregation.getRelationship();
            switch (relationshipType) {
                case 0:
                    result.put(subTableName, subResult);
                    break;
                case 1:
                case 2:
                    List<Map<String, Object>> subResults = new ArrayList<>();
                    subResults.add(subResult);
                    result.put(subTableName, subResults);
                    break;
                default:
                    throw new ApiException(format("未识别的聚合类型:%s", relationshipType));
            }
        }
        //做json转换并返回
        try {
            return new ObjectMapper().writeValueAsString(result);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new ApiException("json转换时出现异常");
        }
    }


}
