package com.tykj.workflowcore.model_layer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;

import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.A;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @ClassName ColumnInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:14
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Data
@NoArgsConstructor
@Entity
@Table(name = "workflow_column_info")
public class ColumnInfo extends BaseEntity  {

    /**
     * 是否primary key， 0是，1否
     */
    @ApiModelProperty("是否主键")
    private Integer primaryKey;

    @ApiModelProperty("列名")
    private String fieldName;

    @ApiModelProperty("列名中文描述")
    private String fieldTitle;
    @ApiModelProperty("列类型")
    private String fieldType;
    @ApiModelProperty("长度")
    private Integer fieldLength;
    @ApiModelProperty("所属表名")
    private String dbName;
    @ApiModelProperty("所属表id")
    private Integer dbId;
    @ApiModelProperty("详细描述")
    private String description;

    public ColumnInfo(Integer primaryKey, String fieldName, String fieldTitle, String fieldType, Integer fieldLength, String dbName, Integer dbId, String description) {
        this.primaryKey = primaryKey;
        this.fieldName = fieldName;
        this.fieldTitle = fieldTitle;
        this.fieldType = fieldType;
        this.fieldLength = fieldLength;
        this.dbName = dbName;
        this.dbId = dbId;
        this.description = description;
    }
}
