package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.base.result.ResultUtil;

import com.tykj.workflowcore.model_layer.entity.vo.*;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.service.ModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:35
 * @Version 1.0
 */
@RestController
@RequestMapping("/model")
@Api(tags = "数据模型层接口")
public class ModelController {

    @Autowired
    private ModelService modelService;


    /**
     * @param
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.TableInfo>
     * @Author WWW
     * @Description 得到所有数据库信息
     * @Date 16:19 2021/3/4
     **/
    @ApiOperation("得到所有数据表信息")
    @PostMapping("/getAllEntity")
    public ResponseEntity getAllEntity(@RequestBody SearchTableInfoVo searchTableInfoVo) {
        Page<TableInfo> tableInfos = null;
        try {
            tableInfos = modelService.listAllEntities(searchTableInfoVo);
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }

        return ResultUtil.success(tableInfos, "数据查询成功！");
    }

    /**
     * @param searchColumnInfoVo
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.ColumnInfo>
     * @Author WWW
     * @Description 根据表名得到所有字段名
     * @Date 16:20 2021/3/4
     **/
    @ApiOperation("根据表名或者id查询表中所有字段")
    @PostMapping("/getAllField")
    public ResponseEntity getFields(@RequestBody SearchColumnInfoVo searchColumnInfoVo) {
        return ResultUtil.success(modelService.showModelFields(searchColumnInfoVo), "数据查询成功！");
    }

    /**
     * @param
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 新增数据模型
     * @Date 16:21 2021/3/4
     **/
    @ApiOperation("新增数据模型")
    @PostMapping(value = "/addModel")
    public ResponseEntity addModel(@RequestBody TableVO tableVO) throws Exception {
        List<TableInfo> tableInfos = modelService.listAllEntities();
        for (TableInfo tableInfo : tableInfos) {
            if (tableVO.getModelName().equals(tableInfo.getModelName())) {
                return ResultUtil.failed("表已经存在！");
            }
        }
        modelService.newTable(tableVO);
        return ResultUtil.success("", "新建成功");

    }

    /**
     * @param map
     * @return int
     * @Author WWW
     * @Description 对应表插入数据
     * map （表名，字段数据）
     * @Date 16:22 2021/3/4
     **/
    @ApiOperation(value = "根据表名表插入数据")
    @PostMapping("/insertValues")
    public ResponseEntity insertValues(@RequestBody Map<String, Object> map) {
        modelService.putValueByEntityName(map);
        return ResultUtil.success("", "数据插入成功");

    }

    /**
     * @param tableName
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 根据表名查询所有数据
     * @Date 9:30 2021/3/11
     **/
    @ApiOperation("根据表名查询所有数据")
    @GetMapping("/getAll")
    public ResponseEntity getAll(String tableName) {
        try {
            return ResultUtil.success(modelService.findAllByName(tableName), "查询成功！");
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return ResultUtil.success(null, "获取失败");
    }
    /**
     * @param tableName
     * @param queryConditions
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 复杂查询
     * @Date 11:03 2021/3/11
     **/
    @ApiOperation("复杂查询")
    @GetMapping("/complexQuery")
    public ResponseEntity complexQuery(String tableName, List<QueryCondition> queryConditions) {
        List list = modelService.complexQuery(tableName, queryConditions);
        if (list != null) {
            return ResultUtil.success(list, "查询成功");
        }
        return ResultUtil.success(null, "没有数据");
    }
    @ApiOperation("编辑操作")
    @PutMapping("/update")
    public ResponseEntity updateTable(@RequestBody UpdateTableInfoVO updateTableInfoVO){
        modelService.updateTable(updateTableInfoVO);
        return ResultUtil.success("","修改成功！");
    }
    @ApiOperation("删除操作")
    @DeleteMapping("/delete")
    public ResponseEntity delTable(DelTableVO delTableVO) throws SQLException {
        modelService.delTable(delTableVO);
        return ResultUtil.success(modelService.findAllByName(delTableVO.getDbName()),"删除成功！");
    }


}
