package com.tykj.workflowcore.workflow_editer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.dao.VariableStorageMapper;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchVariableStorageVo;
import com.tykj.workflowcore.workflow_editer.service.VariableStorageService;
import liquibase.pro.packaged.B;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    VariableStorageServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   10:13
 *
 * @Author: zsp
 */
@Service
public class VariableStorageServiceImpl implements VariableStorageService {

    private final VariableStorageMapper variableStorageMapper;

    public VariableStorageServiceImpl(VariableStorageMapper variableStorageMapper) {
        this.variableStorageMapper = variableStorageMapper;
    }

    @Override
    public VariableStorage saveVariableStorageService(@RequestBody VariableStorage variableStorage) {
        return variableStorageMapper.save(variableStorage);
    }

    @Override
    public List<VariableStorage> searchVariableStorageList(SearchVariableStorageVo searchVariableStorageVo) {
        PredicateBuilder predicateBuilder = Specifications.and();
        if (searchVariableStorageVo!=null){
            predicateBuilder.eq(searchVariableStorageVo.getId()!=null,"id",searchVariableStorageVo.getId());
            predicateBuilder.eq(searchVariableStorageVo.getFlowKey()!=null,"flowKey",searchVariableStorageVo.getFlowKey());
            predicateBuilder.eq(searchVariableStorageVo.getActivityId()!=null,"activityId",searchVariableStorageVo.getActivityId());
        }
        return variableStorageMapper.findAll(predicateBuilder.build());
    }

    @Override
    public Page<VariableStorage> searchVariableStoragePage(SearchVariableStorageVo searchVariableStorageVo) {
        PredicateBuilder predicateBuilder = Specifications.and();
        if (searchVariableStorageVo!=null){
            predicateBuilder.eq(searchVariableStorageVo.getId()!=null,"id",searchVariableStorageVo.getId());
            predicateBuilder.eq(StringUtils.isEmpty(searchVariableStorageVo.getFlowKey()),"flowKey",searchVariableStorageVo.getFlowKey());
            predicateBuilder.eq(StringUtils.isEmpty(searchVariableStorageVo.getActivityId()),"activityId",searchVariableStorageVo.getActivityId());
        }
        return variableStorageMapper.findAll(predicateBuilder.build(),searchVariableStorageVo.getPageable());
    }



}
