package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * ClassName:    UserController
 * Package:    com.tykj.workflowcore.workflow_editer.controller
 * Description:
 * Datetime:    2021/3/24   18:56
 *
 * @Author: zsp
 */
@RestController
@Api(tags = "人员管理接口")
@RequestMapping("/user")
public class UserController {

    @Autowired
    private UserService userService;

    @GetMapping("/getAllUsers")
    @ApiOperation(value = "查询所有用户")
    public List<WorkFlowUser> getAllUsers(){
        List<WorkFlowUser> allUser = userService.getAllUser();
        return allUser;
    }

    @GetMapping("/getAllRoles")
    @ApiOperation(value = "查询所有的角色类型")
    public List<WorkFlowRoleType> getAllRoles(){
        List<WorkFlowRoleType> roleType = userService.getRoleType();
        return roleType;
    }

    @GetMapping("/getAllUserByRole")
    @ApiOperation(value = "查询所有的角色类型下的所有角色")
    public List<WorkFlowRole> getAllUserByRole(String roleType){
        List<WorkFlowRole> allRole = userService.getAllRole(roleType);
        return allRole;
    }
}
