package com.tykj.workflowcore.workflow_editer.validate;

import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.*;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * ClassName:    UserTaskValidator
 * Package:    com.example.config
 * Description:
 * Datetime:    2021/3/26   13:49
 *
 * @Author: zsp
 */
//在部署流程之前需要校验流程中的所有用户任务是否指定办理人
public class UserTaskValidator extends ProcessLevelValidator {

    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        //判断用户节点
        List<UserTask> userTaskList = process.findFlowElementsOfType(UserTask.class);
        //判断结束节点
        List<EndEvent> endEvents = process.findFlowElementsOfType(EndEvent.class);
        //判断开始节点
        List<StartEvent> startEvents = process.findFlowElementsOfType(StartEvent.class);

        if (userTaskList.size() > 0) {
            for (UserTask userTask : userTaskList) {
                if (userTask.getName() == null || userTask.getName().equals("")) {
                    errors.add(createValidationErrorProblem("用户名称为空,请填写"));
                }
                List<SequenceFlow> incomingFlows = userTask.getIncomingFlows();
                if (incomingFlows.size() == 0 || incomingFlows.equals("")) {
                    errors.add(createValidationErrorProblem("缺少连接用户任务的输入流"));
                }
                List<SequenceFlow> outgoingFlows = userTask.getOutgoingFlows();
                if (outgoingFlows.size() == 0 || outgoingFlows.equals("")) {
                    errors.add(createValidationErrorProblem("缺少连接用户任务的输出流"));
                }
                List<String> candidateUsers = userTask.getCandidateUsers();
                List<String> candidateGroups = userTask.getCandidateGroups();

                if ((candidateUsers.size() == 0 || candidateUsers.equals("")) && (candidateGroups.size() == 0 || candidateGroups.equals(""))) {
                    errors.add(createValidationErrorProblem("用户节点未设置用户或者未设置用户组"));
                }

            }
        }

        if (startEvents!=null&&startEvents.size()<=0){
            errors.add(createValidationErrorProblem("开始节点不存在"));
        }else {
            for (StartEvent startEvent : startEvents) {
                List<SequenceFlow> outgoingFlows = startEvent.getOutgoingFlows();
                if (outgoingFlows.size() == 0 || outgoingFlows.equals("")){
                    errors.add(createValidationErrorProblem("开始节点未连接"));
                }
            }
        }

        if (endEvents!=null&&endEvents.size()<=0){
            errors.add(createValidationErrorProblem("结束节点不存在"));
        }else {
            for (EndEvent endEvent : endEvents) {
                List<SequenceFlow> incomingFlows = endEvent.getIncomingFlows();
                if (incomingFlows.size() == 0 || incomingFlows.equals("")){
                    errors.add(createValidationErrorProblem("结束节点未连接"));
                }
            }
        }
        //判断网关
        List<ExclusiveGateway> exclusiveGateways = process.findFlowElementsOfType(ExclusiveGateway.class);
        for (ExclusiveGateway exclusiveGateway : exclusiveGateways) {
            //输出流
            List<SequenceFlow> outgoingFlows = exclusiveGateway.getOutgoingFlows();
            if (outgoingFlows.size() == 0 || outgoingFlows.equals("")){
                errors.add(createValidationErrorProblem("缺少连接网关的输入流"));
            }
            //输入流
            List<SequenceFlow> incomingFlows = exclusiveGateway.getIncomingFlows();
            if (incomingFlows.size() == 0 || incomingFlows.equals("")){
                errors.add(createValidationErrorProblem("缺少连接网关的输出流"));
            }
        }

    }

    public ValidationError createValidationErrorProblem(String message){
        ValidationError validationError = new ValidationError();
        validationError.setProblem(message);
        validationError.setWarning(true);
        return validationError;
    }

}