package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * ClassName:    WorkFlowController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/2   9:48
 *
 * @Author: zsp
 */
@Api(tags = "工作流管理接口")
@RestController
@RequestMapping("/workFlow")
public class WorkFlowController {

    @Autowired
    private WorkFlowService workFlowService;


    @PostMapping("/startFlow")
    @ApiOperation("开启流程")
    public ResponseEntity startFlow(@RequestBody StartFlowVo startFlowVo){
        workFlowService.startFlow(startFlowVo);
        return ResultUtil.success("流程开启成功");
    }

    @GetMapping("/deployFlow")
    @ApiOperation("部署流程")
    public ResponseEntity deployFlow(Integer id) throws FileNotFoundException {
        workFlowService.deployXml(id);
        return ResultUtil.success("流程部署成功");
    }

    @PostMapping("/findUserTask")
    @ApiOperation("任务个人待办列表")
    public List<Map<String,Object>> findUserTask(@RequestBody NextTaskVo nextTaskVo){
        return workFlowService.findTaskByUserId(nextTaskVo);
    }

    @GetMapping("/findTaskDetail")
    @ApiOperation("任务个人待办任务详情")
    public Map<String, Object> findTaskDetail(String taskId){
        return  workFlowService.findTaskDetail(taskId);
    }

    @PostMapping("/completeTask")
    @ApiOperation("完成任务")
    public ResponseEntity completeTask(@RequestBody TaskVo taskVo){
        workFlowService.completeTask(taskVo);
        return ResultUtil.success("任务已完成");
    }

    @PostMapping("/isTransferTask")
    @ApiOperation("是否转交任务")
    public ResponseEntity isTransferTask(@RequestBody TransferTask transferTask){
        workFlowService.transferTask(transferTask);
        return ResultUtil.success("该任务转交成功");
    }

    @GetMapping("/isSuspension")
    @ApiOperation("是否挂起")
    public ResponseEntity isSuspension(Integer id){
        workFlowService.suspendOrActivateProcessDefinitionByKey(id);
        return ResultUtil.success("该流程已经成功"+(id==0?"启用":"禁用"));
    }

    @DeleteMapping("/deleteFlow")
    @ApiOperation("是否删除")
    public ResponseEntity deleteFlow(Integer id){
        workFlowService.deleteFlow(id);
        return ResultUtil.success("该流程删除成功");
    }

    @PostMapping("/flowProgress")
    @ApiOperation("流程进度")
    public void flowProgress(@RequestBody FlowProcessVo flowProcessVo) throws IOException {
        workFlowService.flowProgress(flowProcessVo.getResponse(),flowProcessVo.getProcessInstanceId());
    }

    @GetMapping("/findHistoryTask")
    @ApiOperation("已办任务")
    public List findHistoryTask() {
       return workFlowService.findHistoryTask();
    }



}
