package com.tykj.workflowcore.model_layer.service.impl;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.model_layer.dao.AggregationRelationshipDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoExDao;

import com.tykj.workflowcore.model_layer.entity.Aggregation;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.TableInfoEx;
import com.tykj.workflowcore.model_layer.entity.vo.AggregationVO;
import com.tykj.workflowcore.model_layer.myEnum.AggregationType;
import com.tykj.workflowcore.model_layer.service.AggregationService;
import com.tykj.workflowcore.model_layer.utils.AggregationUtil;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.util.Optional;
import java.util.UUID;

/**
 * @ClassName AggregationImpl
 * @Description TODO
 * @Author WWW
 * @Date 2021/4/1 17:24
 * @Version 1.0
 */
@Service
public class AggregationImpl implements AggregationService {

    @Autowired
    TableInfoDao tableInfoDao;
    @Autowired
    TableInfoExDao tableInfoExDao;
    @Autowired
    AggregationRelationshipDao aggregationRelationshipDao;

    @Override
    public void addAggregation(AggregationVO aggregationVO) {
        Document mainTableDocument;
        //获取主表XML
        Integer mainTableId = aggregationVO.getMainTableId();
        Optional<TableInfo> mainTableById = tableInfoDao.findById(mainTableId);
        if (mainTableById.isPresent()){
            mainTableDocument = AggregationUtil.getDocument(mainTableById.get().getXml());
        }else {
            throw new ApiException("主表不存在");
        }
        //改CLASS名字
        AggregationUtil.changeClassName(aggregationVO.getName(),mainTableDocument );
        // save TableInfoEx  （name des mainTableId）
        TableInfoEx tableInfoEx = tableInfoExDao.save(aggregationVO.getTableInfoEx());
//        遍历VO 根据聚合类型 生成对应的 XML 节点 并添加到DOCUMENT中
        for (Aggregation aggregationRelationship : aggregationVO.getLists()) {
            //取出副表的tableInfo
            Optional<TableInfo> sideTableById = tableInfoDao.findById(aggregationRelationship.getSideTableId());
            aggregationRelationship.setTableInfoExId(tableInfoEx.getId());
            if (!sideTableById.isPresent()){
                throw new ApiException("id为："+aggregationRelationship.getSideTableId()+"的副表不存在");
            }
            if (aggregationRelationship.getRelationship().equals(AggregationType.ONE_TO_ONE)){
                Document document = AggregationUtil.addOneToOne(aggregationRelationship.getSideTableConnectionKey(), sideTableById.get().getModelName(), mainTableDocument);
                tableInfoEx.setXml(document.asXML());

            }
            if (aggregationRelationship.getRelationship().equals(AggregationType.ONE_TO_MANY)){
                //如果是一对多需要 为 aggregationRelationship 生成连接的KEY
                String mainTableConnectionKey = sideTableById.get().getModelName()+"_list";
                Document document =   AggregationUtil.addOneToMany(sideTableById.get().getModelName(), mainTableConnectionKey, aggregationRelationship.getSideTableConnectionKey(), mainTableDocument);
                tableInfoEx.setXml(document.asXML());
            }
            if (aggregationRelationship.getRelationship().equals(AggregationType.MANY_TO_MANY)){
                //如果是多对多需要 为 aggregationRelationship 生成连接的KEY
                String mainTableConnectionKey = mainTableById.get().getModelName()+"_Id";
                String sideTableConnectionKey = sideTableById.get().getModelName()+"_Id";
                aggregationRelationship.setMainTableConnectionKey(mainTableConnectionKey);
                aggregationRelationship.setSideTableConnectionKey(sideTableConnectionKey);
                //如果是多对多需要 为 aggregationRelationship 生成连接的中间表名
                String connectionTableName = mainTableById.get().getModelName()+"_"+sideTableById.get().getModelName()+"_"+ (UUID.randomUUID().toString().substring(0,8));
                aggregationRelationship.setConnectionTableName(connectionTableName);
                //Util.addManyToMany
                Document document =  AggregationUtil.addManyToMany(sideTableById.get().getModelName(),connectionTableName,mainTableConnectionKey,sideTableConnectionKey,mainTableDocument);
                tableInfoEx.setXml(document.asXML());
            }
            aggregationRelationshipDao.save(aggregationRelationship);
        }
    }
}
