package com.tykj.workflowcore.model_layer.service.impl;

import com.alibaba.fastjson.JSON;
import com.tykj.workflowcore.model_layer.dao.AggregationDao;
import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoExDao;
import com.tykj.workflowcore.model_layer.entity.Aggregation;
import com.tykj.workflowcore.model_layer.entity.ColumnInfo;
import com.tykj.workflowcore.model_layer.entity.TableInfoEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static java.lang.String.format;

@Service
public class ModelHelper {

    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private ColumnInfoDao columnInfoDao;
    @Autowired
    private TableInfoExDao tableInfoExDao;
    @Autowired
    private AggregationDao aggregationDao;

    public String getJsonExample(Integer tableInfoExId) {
        TableInfoEx tableInfoEX = tableInfoExDao.findById(tableInfoExId)
                .orElseThrow(() -> new RuntimeException(format("未找到该id的数据:%s", tableInfoExId)));
        Map<String, Object> result = new HashMap<>();
        List<ColumnInfo> columnInfos = columnInfoDao.findAllByDbId(tableInfoEX.getMainTableId());
        for (ColumnInfo columnInfo : columnInfos) {
            result.put(columnInfo.getFieldName(), null);
        }
        List<Aggregation> relationships = aggregationDao.findAllByTableInfoExId(tableInfoExId);
        for (Aggregation relationship : relationships) {
            List<ColumnInfo> subColumnInfos = columnInfoDao.findAllByDbId(relationship.getSideTableId());
            Map<String, Object> subResult = new HashMap<>();
            for (ColumnInfo subColumnInfo : subColumnInfos) {
                subResult.put(subColumnInfo.getFieldName(), null);
            }
            String connectionTableName = relationship.getConnectionTableName();
            Integer relationshipType = relationship.getRelationship();
            switch (relationshipType) {
                case 0:
                    result.put(connectionTableName, subResult);
                    break;
                case 1:
                case 2:
                    List<Map<String, Object>> subResults = new ArrayList<>();
                    subResults.add(subResult);
                    result.put(connectionTableName, subResults);
                    break;
                default:
                    throw new RuntimeException(format("未识别的聚合类型:%s", relationshipType));
            }
        }
        return JSON.toJSONString(result);
    }


}
