package com.tykj.workflowcore.model_layer.utils;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.model_layer.myEnum.AggregationType;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;




/**
 * @ClassName AggregationUtil
 * @Description TODO 生成聚合对象xml
 * @Author WWW
 * @Date 2021/4/1 18:59
 * @Version 1.0
 */
public class AggregationUtil {
    //xml工具

    public static Document getDocument(String xml){
        try {
            return DocumentHelper.parseText(xml);
        } catch (DocumentException e) {
            throw new ApiException("XML格式不正确");
        }
    }

    public static Document changeClassName(String className,Document document){
        Element aClass = getNode(document);
        aClass.attribute("entity-name").setValue(className);
        return aClass.getDocument();
    }

    public static Document addOneToOne(String field, String sideTableName,Document document) {
        Element element = DocumentHelper.createElement("one-to-one");
        element.addAttribute("name", field);
        element.addAttribute("class", sideTableName);
        element.addAttribute("cascade", "save-update");
        Element classElement = getNode(document);
        classElement.add(element);
        return document;
    }

    public static Document addOneToMany(String sideTableName,String mainTableConnectionKey, String sideTableConnectionKey,Document document) {
        //创建ELEMETN
        Element setElement = createSetElement(mainTableConnectionKey,sideTableName, "", mainTableConnectionKey, sideTableConnectionKey,  AggregationType.ONE_TO_MANY);
        //创建结束
        Element classElement = getNode(document);
        classElement.add(setElement);
        return document;
    }



    public static Document addManyToMany(String sideTableName,String connectionTableName,String mainTableConnectionKey, String sideTableConnectionKey,Document document) {
        Element setElement = createSetElement(sideTableName,sideTableName, connectionTableName, mainTableConnectionKey, sideTableConnectionKey, AggregationType.MANY_TO_MANY);
        //创建结束
        Element classElement = getNode(document);
        classElement.add(setElement);
        return document;
    }

    public static Element getNode(Document document) {
        return document.getRootElement().element("class");
    }

    public static Element createSetElement(String setName,String sideTableName,String connectionTableName,String mainTableConnectionKey, String sideTableConnectionKey,Integer type){
        //创建ELEMTN
        Element elementSet = DocumentHelper.createElement("set");
        elementSet.addAttribute("name", setName);
        elementSet.addAttribute("cascade", "save-update");
        Element elementKey = DocumentHelper.createElement("key");
        if (type.equals(AggregationType.MANY_TO_MANY)){
            elementSet.addAttribute("table", connectionTableName);
            elementKey.addAttribute("column",mainTableConnectionKey);
            elementSet.add(elementKey);
            Element elementManyToMany = DocumentHelper.createElement("many-to-many");
            elementManyToMany.addAttribute("class",sideTableName);
            elementManyToMany.addAttribute("column",sideTableConnectionKey);
            elementSet.add(elementManyToMany);
        }else if (type.equals(AggregationType.ONE_TO_MANY)){
            elementKey.addAttribute("column",sideTableConnectionKey);
            elementSet.add(elementKey);
            Element elementOneToMany = DocumentHelper.createElement("one-to-many");
            elementOneToMany.addAttribute("class",sideTableName);
            elementSet.add(elementOneToMany);
        }

        return elementSet;
    }

//    字符串拼接
//    private static String xmlStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
//            "<!DOCTYPE hibernate-mapping PUBLIC\n" +
//            "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
//            "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
//            "<hibernate-mapping>";
//
//    private static String xmlEnd = "</hibernate-mapping>";
//
//
//    public static String getOldProperty(String xml) {
//        String property = "";
//        Document document = null;
//        try {
//            document = DocumentHelper.parseText(xml);
//        } catch (DocumentException e) {
//            e.printStackTrace();
//        }
//        List<Element> elements = document.getRootElement().elements().get(0).elements();
//        for (Element element : elements) {
//            property = property + element.asXML();
//        }
//        return property;
//    }
//
//

//
//
//    public static String addOneToMany(String mainTable, String sideTable, String mainField, String xml) {
//
//
//        String addStr =
//                "<class entity-name= \"" +mainTable + "_" + sideTable + "\""+" table=\"" + mainTable +"\""+ ">\n" +
//                        getOldProperty(xml) +
//                        " <set name=\"" + sideTable + "_list" + "\""+" inverse=\"true\" lazy=\"true\">\n" +
//                        "     <key column=\"" + mainField + "\""+"/>\n" +
//                        "     <one-to-many class=\"" + sideTable +"\""+ "/>\n" +
//                        "</set>\n" +
//                        "   </class>";
//
//
//        return xmlStart+ addStr+xmlEnd;
//    }
//
//
//    public static String addManyToMany(String mainTable, String sideTable, String xml) {
//
//        String entityName = mainTable + "_" + sideTable + "_ref";
//
//        String addStr = "<class entity-name=\"" + entityName +"\""+ " table=\"" + mainTable +"\""+ ">\n" +
//                " \n"
//                +
//                getOldProperty(xml)
//                +
//                " <set name=\"" + sideTable+"\"" + " table=\"" + entityName+"\"" + ">\n" +
//                " \t<key column=\"" + mainTable + "_id" +"\""+ "/>\n" +
//                " \t<many-to-many class=\"" + sideTable +"\""+ " column=\"" + sideTable +"\""+ "_id" + "/>\n" +
//                " </set>" +
//                "</class>";
//        return xmlStart+ addStr+xmlEnd;
//    }
//



}
