package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;

/**
 * ClassName:    NodePage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   13:08
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@WorkFlowCoreNoScan
@Api("节点信息")
public class NodeInfo extends BaseEntity {


    @ApiModelProperty("节点id")
    private String nodeId;

    @ApiModelProperty("页面id")
    private Integer pageId;

    @ApiModelProperty("流程key")
    private String flowKey;

    @ApiModelProperty("流程名")
    private String flowName;

    @ApiModelProperty("候选人类型")
    private String candidateType;

    @ApiModelProperty("候选人显示值")
    private String candidateLabel;

    @ApiModelProperty("候选人显示值")
    private String candidateValue;

    @ApiModelProperty("0为默认,1为可视,2为公式")
    private Integer expressionType;

    @ApiModelProperty("输入框中的值  例如： 同意，不同意")
    private Integer expressionValue;

    @ApiModelProperty("连接条件")
    private String expressionConnectionConditions;

    @ApiModelProperty("判断条件拼接字段  例如：[{'resource':'${people.id}','comparator':'>=','value':'10'}]")
    private String expressionCondition;

}
