package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.TableAndColumnInfoVO;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.entity.vo.FormPageVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.PageFormPageVo;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    PageEntityService
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/3/3   13:14
 *
 * @Author: zsp
 */
public interface FormPageService {

    /**
     * 保存页面
     * @param inFormPageVo 页面实体
     * @return 主键id
     */
    Integer savePage(@RequestBody FormPageVo inFormPageVo);

    /**
     *  更新页面
     * @param formPage 页面实体
     * @return 主键id
     */
    void update(FormPage formPage);
    /**
     * 根据页面id来进行回显
     * @param id 页面id
     * @return 页面信息
     */
    FormPageVo getPage(Integer id);

    /**
     * 根据页面id删除页面
     * @param id 页面id
     */
    void deletePage(Integer id);

    /**
     * 查询全部页面
     * @param pageFormPageVo 分页
     * @return 全部集合
     */
    Page<FormPage> getAllPages(PageFormPageVo pageFormPageVo);

    /**
     * 根据页面id查询tableInfo
     * @param pageIds 页面id
     * @return
     */
    TableAndColumnInfoVO findByPageIds(List<Integer> pageIds);
}
