package com.tykj.workflowcore;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.workflow_editer.controller.FlowsInfoController;
import com.tykj.workflowcore.workflow_editer.controller.WorkFlowController;
import org.aspectj.lang.annotation.Before;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import springfox.documentation.spring.web.json.Json;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import static org.hamcrest.Matchers.equalToObject;
import static org.hamcrest.Matchers.not;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureMockMvc
class WorkflowCoreApplicationTests_workflow {

    @Autowired
    private FlowsInfoController flowsInfoController;

    @Autowired
    private WorkFlowController workFlowController;
    @Autowired
    MockMvc mockMvc;

    RequestBuilder request;

    @Before("")
    public void setUp() {
        mockMvc = MockMvcBuilders.standaloneSetup(flowsInfoController).build();
        mockMvc = MockMvcBuilders.standaloneSetup(workFlowController).build();
    }

    @Test
    //部署流程
    void deployFlow() throws Exception {
//        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
//                "<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bpmn2=\"http://www" +
//                ".omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" " +
//                "xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:di=\"http://www.omg" +
//                ".org/spec/DD/20100524/DI\" xmlns:flowable=\"http://flowable.org/bpmn\" targetNamespace=\"http://bpmn" +
//                ".io/schema/bpmn\">\n" +
//                "  <bpmn2:process id=\"processId_fb773ab4-4d09-4f9f-b1d1-2cdb3805d02b\" name=\"第一次完整的测试\" " +
//                "isExecutable=\"true\">\n" +
//                "    <bpmn2:documentation>这是第一次完整的测试</bpmn2:documentation>\n" +
//                "    <bpmn2:startEvent id=\"StartEvent_6dae980e-109d-4bdf-a4e8-7bcd1fed3517\" name=\"开始\">\n" +
//                "      <bpmn2:outgoing>Flow_1tfbtm6</bpmn2:outgoing>\n" +
//                "    </bpmn2:startEvent>\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_1tfbtm6\" " +
//                "sourceRef=\"StartEvent_6dae980e-109d-4bdf-a4e8-7bcd1fed3517\" " +
//                "targetRef=\"Activity_a750f23d-4cf2-49c6-9232-2d0a07c9221f\" />\n" +
//                "    <bpmn2:userTask id=\"Activity_a750f23d-4cf2-49c6-9232-2d0a07c9221f\" name=\"开始审批请假\" " +
//                "flowable:candidateUsers=\"0,1,2,3\">\n" +
//                "      <bpmn2:incoming>Flow_1tfbtm6</bpmn2:incoming>\n" +
//                "      <bpmn2:outgoing>Flow_022g1sr</bpmn2:outgoing>\n" +
//                "    </bpmn2:userTask>\n" +
//                "    <bpmn2:exclusiveGateway id=\"Gateway_0f788cb8-b0a7-4867-ba7f-396df0b9c65a\">\n" +
//                "      <bpmn2:incoming>Flow_022g1sr</bpmn2:incoming>\n" +
//                "      <bpmn2:outgoing>Flow_cee3b49d-ebc5-45e3-a182-954d1ab60cdb</bpmn2:outgoing>\n" +
//                "      <bpmn2:outgoing>Flow_a4bc9aa7-25be-40c9-8b06-20563560a19a</bpmn2:outgoing>\n" +
//                "    </bpmn2:exclusiveGateway>\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_022g1sr\" " +
//                "sourceRef=\"Activity_a750f23d-4cf2-49c6-9232-2d0a07c9221f\" " +
//                "targetRef=\"Gateway_0f788cb8-b0a7-4867-ba7f-396df0b9c65a\" />\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_cee3b49d-ebc5-45e3-a182-954d1ab60cdb\" name=\"同意\" " +
//                "sourceRef=\"Gateway_0f788cb8-b0a7-4867-ba7f-396df0b9c65a\" " +
//                "targetRef=\"Activity_b8a67160-7332-4185-a782-1be95be7233a\">\n" +
//                "      <bpmn2:conditionExpression xsi:type=\"bpmn2:tFormalExpression\">${handlingOpinion " +
//                "== 0}</bpmn2:conditionExpression>\n" +
//                "    </bpmn2:sequenceFlow>\n" +
//                "    <bpmn2:userTask id=\"Activity_b8a67160-7332-4185-a782-1be95be7233a\" name=\"人事备案\" " +
//                "flowable:candidateUsers=\"1\">\n" +
//                "      <bpmn2:incoming>Flow_cee3b49d-ebc5-45e3-a182-954d1ab60cdb</bpmn2:incoming>\n" +
//                "      <bpmn2:outgoing>Flow_0pp1clp</bpmn2:outgoing>\n" +
//                "    </bpmn2:userTask>\n" +
//                "    <bpmn2:endEvent id=\"Event_5505a99e-25c8-4378-bb95-4c76bf370f44\" name=\"结束\">\n" +
//                "      <bpmn2:incoming>Flow_0pp1clp</bpmn2:incoming>\n" +
//                "      <bpmn2:incoming>Flow_0cc5fme</bpmn2:incoming>\n" +
//                "    </bpmn2:endEvent>\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_0pp1clp\" " +
//                "sourceRef=\"Activity_b8a67160-7332-4185-a782-1be95be7233a\" " +
//                "targetRef=\"Event_5505a99e-25c8-4378-bb95-4c76bf370f44\" />\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_a4bc9aa7-25be-40c9-8b06-20563560a19a\" name=\"不同意\" " +
//                "sourceRef=\"Gateway_0f788cb8-b0a7-4867-ba7f-396df0b9c65a\" " +
//                "targetRef=\"Activity_c9c101b8-e27e-4e48-8807-c9345f8f3f35\">\n" +
//                "      <bpmn2:conditionExpression xsi:type=\"bpmn2:tFormalExpression\">${handlingOpinion " +
//                "== 1}</bpmn2:conditionExpression>\n" +
//                "    </bpmn2:sequenceFlow>\n" +
//                "    <bpmn2:userTask id=\"Activity_c9c101b8-e27e-4e48-8807-c9345f8f3f35\" name=\"通知用户请假不通过\" " +
//                "flowable:candidateUsers=\"2\">\n" +
//                "      <bpmn2:incoming>Flow_a4bc9aa7-25be-40c9-8b06-20563560a19a</bpmn2:incoming>\n" +
//                "      <bpmn2:outgoing>Flow_0cc5fme</bpmn2:outgoing>\n" +
//                "    </bpmn2:userTask>\n" +
//                "    <bpmn2:sequenceFlow id=\"Flow_0cc5fme\" " +
//                "sourceRef=\"Activity_c9c101b8-e27e-4e48-8807-c9345f8f3f35\" " +
//                "targetRef=\"Event_5505a99e-25c8-4378-bb95-4c76bf370f44\" />\n" +
//                "  </bpmn2:process>\n" +
//                "  <bpmndi:BPMNDiagram id=\"BPMNDiagram_1\">\n" +
//                "    <bpmndi:BPMNPlane id=\"BPMNPlane_1\" " +
//                "bpmnElement=\"processId_fb773ab4-4d09-4f9f-b1d1-2cdb3805d02b\">\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_1tfbtm6_di\" bpmnElement=\"Flow_1tfbtm6\">\n" +
//                "        <di:waypoint x=\"196\" y=\"178\" />\n" +
//                "        <di:waypoint x=\"270\" y=\"178\" />\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_022g1sr_di\" bpmnElement=\"Flow_022g1sr\">\n" +
//                "        <di:waypoint x=\"370\" y=\"178\" />\n" +
//                "        <di:waypoint x=\"405\" y=\"178\" />\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_14iep5w_di\" " +
//                "bpmnElement=\"Flow_cee3b49d-ebc5-45e3-a182-954d1ab60cdb\">\n" +
//                "        <di:waypoint x=\"455\" y=\"178\" />\n" +
//                "        <di:waypoint x=\"510\" y=\"178\" />\n" +
//                "        <bpmndi:BPMNLabel>\n" +
//                "          <dc:Bounds x=\"471\" y=\"160\" width=\"23\" height=\"14\" />\n" +
//                "        </bpmndi:BPMNLabel>\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_0pp1clp_di\" bpmnElement=\"Flow_0pp1clp\">\n" +
//                "        <di:waypoint x=\"610\" y=\"178\" />\n" +
//                "        <di:waypoint x=\"672\" y=\"178\" />\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_0coa6ri_di\" " +
//                "bpmnElement=\"Flow_a4bc9aa7-25be-40c9-8b06-20563560a19a\">\n" +
//                "        <di:waypoint x=\"430\" y=\"203\" />\n" +
//                "        <di:waypoint x=\"430\" y=\"310\" />\n" +
//                "        <di:waypoint x=\"510\" y=\"310\" />\n" +
//                "        <bpmndi:BPMNLabel>\n" +
//                "          <dc:Bounds x=\"428\" y=\"254\" width=\"34\" height=\"14\" />\n" +
//                "        </bpmndi:BPMNLabel>\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNEdge id=\"Flow_0cc5fme_di\" bpmnElement=\"Flow_0cc5fme\">\n" +
//                "        <di:waypoint x=\"610\" y=\"310\" />\n" +
//                "        <di:waypoint x=\"641\" y=\"310\" />\n" +
//                "        <di:waypoint x=\"641\" y=\"178\" />\n" +
//                "        <di:waypoint x=\"672\" y=\"178\" />\n" +
//                "      </bpmndi:BPMNEdge>\n" +
//                "      <bpmndi:BPMNShape id=\"_BPMNShape_StartEvent_2\" " +
//                "bpmnElement=\"StartEvent_6dae980e-109d-4bdf-a4e8-7bcd1fed3517\">\n" +
//                "        <dc:Bounds x=\"160\" y=\"160\" width=\"36\" height=\"36\" />\n" +
//                "        <bpmndi:BPMNLabel>\n" +
//                "          <dc:Bounds x=\"167\" y=\"203\" width=\"23\" height=\"14\" />\n" +
//                "        </bpmndi:BPMNLabel>\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "      <bpmndi:BPMNShape id=\"Gateway_069z61g_di\" " +
//                "bpmnElement=\"Gateway_0f788cb8-b0a7-4867-ba7f-396df0b9c65a\" isMarkerVisible=\"true\">\n" +
//                "        <dc:Bounds x=\"405\" y=\"153\" width=\"50\" height=\"50\" />\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "      <bpmndi:BPMNShape id=\"Activity_096xy47_di\" " +
//                "bpmnElement=\"Activity_b8a67160-7332-4185-a782-1be95be7233a\">\n" +
//                "        <dc:Bounds x=\"510\" y=\"138\" width=\"100\" height=\"80\" />\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "      <bpmndi:BPMNShape id=\"Event_0c8zgz5_di\" " +
//                "bpmnElement=\"Event_5505a99e-25c8-4378-bb95-4c76bf370f44\">\n" +
//                "        <dc:Bounds x=\"672\" y=\"160\" width=\"36\" height=\"36\" />\n" +
//                "        <bpmndi:BPMNLabel>\n" +
//                "          <dc:Bounds x=\"679\" y=\"203\" width=\"23\" height=\"14\" />\n" +
//                "        </bpmndi:BPMNLabel>\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "      <bpmndi:BPMNShape id=\"Activity_0wehih5_di\" " +
//                "bpmnElement=\"Activity_c9c101b8-e27e-4e48-8807-c9345f8f3f35\">\n" +
//                "        <dc:Bounds x=\"510\" y=\"270\" width=\"100\" height=\"80\" />\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "      <bpmndi:BPMNShape id=\"Activity_17cgfam_di\" " +
//                "bpmnElement=\"Activity_a750f23d-4cf2-49c6-9232-2d0a07c9221f\">\n" +
//                "        <dc:Bounds x=\"270\" y=\"138\" width=\"100\" height=\"80\" />\n" +
//                "      </bpmndi:BPMNShape>\n" +
//                "    </bpmndi:BPMNPlane>\n" +
//                "  </bpmndi:BPMNDiagram>\n" +
//                "</bpmn2:definitions>\n";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bpmn2=\"http://www" +
                ".omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" " +
                "xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:di=\"http://www.omg" +
                ".org/spec/DD/20100524/DI\" xmlns:flowable=\"http://flowable.org/bpmn\" targetNamespace=\"http://bpmn" +
                ".io/schema/bpmn\">\n" +
                "  <bpmn2:process id=\"processId_1\" name=\"测试1\" " +
                "isExecutable=\"true\">\n" +
                "    <bpmn2:documentation>测试1</bpmn2:documentation>\n" +
                "    <bpmn2:startEvent id=\"StartEvent_11cf0b84-8cf7-4984-b029-2bc2d443be7f\" name=\"开始\">\n" +
                "      <bpmn2:outgoing>Flow_1t7jvmu</bpmn2:outgoing>\n" +
                "    </bpmn2:startEvent>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_1t7jvmu\" " +
                "sourceRef=\"StartEvent_11cf0b84-8cf7-4984-b029-2bc2d443be7f\" " +
                "targetRef=\"Activity_f69a408f-6814-49c9-b6d8-3024c92a12ec\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_1ke0rj0\" " +
                "sourceRef=\"Activity_f69a408f-6814-49c9-b6d8-3024c92a12ec\" " +
                "targetRef=\"Activity_4a50b9c8-2a74-4fff-9376-7b5a0bf5a680\" />\n" +
                "    <bpmn2:exclusiveGateway id=\"Gateway_d7c6c303-7b23-4021-9be0-886f4cb53349\">\n" +
                "      <bpmn2:incoming>Flow_18goqkp</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_120d9e6e-1b95-4f70-8cc7-c0c969776098</bpmn2:outgoing>\n" +
                "      <bpmn2:outgoing>Flow_e593b679-77d1-4c88-8265-e9dffb30006d</bpmn2:outgoing>\n" +
                "    </bpmn2:exclusiveGateway>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_18goqkp\" " +
                "sourceRef=\"Activity_4a50b9c8-2a74-4fff-9376-7b5a0bf5a680\" " +
                "targetRef=\"Gateway_d7c6c303-7b23-4021-9be0-886f4cb53349\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_120d9e6e-1b95-4f70-8cc7-c0c969776098\" " +
                "sourceRef=\"Gateway_d7c6c303-7b23-4021-9be0-886f4cb53349\" " +
                "targetRef=\"Activity_fe37dde6-44c1-4a50-8bd2-b32962ccfcb5\">\n" +
                "      <bpmn2:conditionExpression xsi:type=\"bpmn2:tFormalExpression\"><![CDATA[${handlingOpinion " +
                "== 0}]]></bpmn2:conditionExpression>\n" +
                "    </bpmn2:sequenceFlow>\n" +
                "    <bpmn2:endEvent id=\"Event_40112390-cfe6-4853-96f3-bdf703e77f31\" name=\"结束\">\n" +
                "      <bpmn2:incoming>Flow_166w58n</bpmn2:incoming>\n" +
                "      <bpmn2:incoming>Flow_e593b679-77d1-4c88-8265-e9dffb30006d</bpmn2:incoming>\n" +
                "    </bpmn2:endEvent>\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_166w58n\" " +
                "sourceRef=\"Activity_fe37dde6-44c1-4a50-8bd2-b32962ccfcb5\" " +
                "targetRef=\"Event_40112390-cfe6-4853-96f3-bdf703e77f31\" />\n" +
                "    <bpmn2:sequenceFlow id=\"Flow_e593b679-77d1-4c88-8265-e9dffb30006d\" " +
                "sourceRef=\"Gateway_d7c6c303-7b23-4021-9be0-886f4cb53349\" " +
                "targetRef=\"Event_40112390-cfe6-4853-96f3-bdf703e77f31\">\n" +
                "      <bpmn2:conditionExpression xsi:type=\"bpmn2:tFormalExpression\"><![CDATA[${handlingOpinion " +
                "== 1}]]></bpmn2:conditionExpression>\n" +
                "    </bpmn2:sequenceFlow>\n" +
                "    <bpmn2:userTask id=\"Activity_f69a408f-6814-49c9-b6d8-3024c92a12ec\" name=\"1\" " +
                "flowable:candidateUsers=\"0,1,2\">\n" +
                "      <bpmn2:incoming>Flow_1t7jvmu</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_1ke0rj0</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "    <bpmn2:userTask id=\"Activity_4a50b9c8-2a74-4fff-9376-7b5a0bf5a680\" name=\"2\" " +
                "flowable:candidateGroups=\"department_1\">\n" +
                "      <bpmn2:incoming>Flow_1ke0rj0</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_18goqkp</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "    <bpmn2:userTask id=\"Activity_fe37dde6-44c1-4a50-8bd2-b32962ccfcb5\" name=\"3\" " +
                "flowable:candidateUsers=\"6\">\n" +
                "      <bpmn2:incoming>Flow_120d9e6e-1b95-4f70-8cc7-c0c969776098</bpmn2:incoming>\n" +
                "      <bpmn2:outgoing>Flow_166w58n</bpmn2:outgoing>\n" +
                "    </bpmn2:userTask>\n" +
                "  </bpmn2:process>\n" +
                "  <bpmndi:BPMNDiagram id=\"BPMNDiagram_1\">\n" +
                "    <bpmndi:BPMNPlane id=\"BPMNPlane_1\" " +
                "bpmnElement=\"processId_a3b266fc-0359-4cde-8215-98f9a9797c22\">\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_1t7jvmu_di\" bpmnElement=\"Flow_1t7jvmu\">\n" +
                "        <di:waypoint x=\"196\" y=\"178\" />\n" +
                "        <di:waypoint x=\"250\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_1ke0rj0_di\" bpmnElement=\"Flow_1ke0rj0\">\n" +
                "        <di:waypoint x=\"350\" y=\"178\" />\n" +
                "        <di:waypoint x=\"410\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_18goqkp_di\" bpmnElement=\"Flow_18goqkp\">\n" +
                "        <di:waypoint x=\"510\" y=\"178\" />\n" +
                "        <di:waypoint x=\"575\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_0t6e45t_di\" " +
                "bpmnElement=\"Flow_120d9e6e-1b95-4f70-8cc7-c0c969776098\">\n" +
                "        <di:waypoint x=\"600\" y=\"203\" />\n" +
                "        <di:waypoint x=\"600\" y=\"370\" />\n" +
                "        <di:waypoint x=\"650\" y=\"370\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_166w58n_di\" bpmnElement=\"Flow_166w58n\">\n" +
                "        <di:waypoint x=\"750\" y=\"370\" />\n" +
                "        <di:waypoint x=\"806\" y=\"370\" />\n" +
                "        <di:waypoint x=\"806\" y=\"178\" />\n" +
                "        <di:waypoint x=\"862\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNEdge id=\"Flow_1fwrst6_di\" " +
                "bpmnElement=\"Flow_e593b679-77d1-4c88-8265-e9dffb30006d\">\n" +
                "        <di:waypoint x=\"625\" y=\"178\" />\n" +
                "        <di:waypoint x=\"862\" y=\"178\" />\n" +
                "      </bpmndi:BPMNEdge>\n" +
                "      <bpmndi:BPMNShape id=\"_BPMNShape_StartEvent_2\" " +
                "bpmnElement=\"StartEvent_11cf0b84-8cf7-4984-b029-2bc2d443be7f\">\n" +
                "        <dc:Bounds x=\"160\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "        <bpmndi:BPMNLabel>\n" +
                "          <dc:Bounds x=\"167\" y=\"203\" width=\"22\" height=\"14\" />\n" +
                "        </bpmndi:BPMNLabel>\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Gateway_1vn7rsw_di\" " +
                "bpmnElement=\"Gateway_d7c6c303-7b23-4021-9be0-886f4cb53349\" isMarkerVisible=\"true\">\n" +
                "        <dc:Bounds x=\"575\" y=\"153\" width=\"50\" height=\"50\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Event_1iat3a3_di\" " +
                "bpmnElement=\"Event_40112390-cfe6-4853-96f3-bdf703e77f31\">\n" +
                "        <dc:Bounds x=\"862\" y=\"160\" width=\"36\" height=\"36\" />\n" +
                "        <bpmndi:BPMNLabel>\n" +
                "          <dc:Bounds x=\"869\" y=\"203\" width=\"22\" height=\"14\" />\n" +
                "        </bpmndi:BPMNLabel>\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_0ll4t0b_di\" " +
                "bpmnElement=\"Activity_f69a408f-6814-49c9-b6d8-3024c92a12ec\">\n" +
                "        <dc:Bounds x=\"250\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_1vv2tlo_di\" " +
                "bpmnElement=\"Activity_4a50b9c8-2a74-4fff-9376-7b5a0bf5a680\">\n" +
                "        <dc:Bounds x=\"410\" y=\"138\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "      <bpmndi:BPMNShape id=\"Activity_0t2an3h_di\" " +
                "bpmnElement=\"Activity_fe37dde6-44c1-4a50-8bd2-b32962ccfcb5\">\n" +
                "        <dc:Bounds x=\"650\" y=\"330\" width=\"100\" height=\"80\" />\n" +
                "      </bpmndi:BPMNShape>\n" +
                "    </bpmndi:BPMNPlane>\n" +
                "  </bpmndi:BPMNDiagram>\n" +
                "</bpmn2:definitions>\n";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileXml",xml);
        jsonObject.put("flowKey","processId_fb773ab4-4d09-4f9f-b1d1-2cdb3805d02b");
        jsonObject.put("flowName","第一次完整的测试");

        request = post("/flowsInfo/saveXml/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("fileXml",xml)//参数
//                .param("flowKey","processId_df8ce31c-c23c-4e5d-8401-e4e99286dba8")//参数
//                .param("flowName","processName_2")
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test
        //开启流程
    void startFlow() throws Exception {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowKey","processId_1");
        JSONObject jsonObject1 = new JSONObject();
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("id","5");
        jsonObject2.put("userName","张三");

        jsonObject1.put("workFlowUser",jsonObject2);
        jsonObject.put("map",jsonObject1);
        request = post("/workFlow/startFlow/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("fileXml",xml)//参数
//                .param("flowKey","processId_df8ce31c-c23c-4e5d-8401-e4e99286dba8")//参数
//                .param("flowName","processName_2")
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
//                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }
    @Test
        //查询代办
    void findUserTask() throws Exception {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userId","0");
        request = post("/workFlow/findUserTask/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
//                .param("userId","0")//参数
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test
        //查询代办详情
    void findUserTaskDetail() throws Exception {

//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("taskId","2563cd2d-8c72-11eb-9463-005056c00001");
        request = get(URI.create("/workFlow/findUserTask/"))
                .contentType(MediaType.APPLICATION_JSON)
                .param("taskId","8d1f5032-9068-11eb-a31d-005056c00008")//参数
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test //完成任务
    void complteTask() throws Exception {

        JSONObject jsonObject = new JSONObject();
        JSONObject jsonMap = new JSONObject();
        jsonMap.put("id",1);
        jsonMap.put("userName","李四");
        jsonObject.put("workFlowUser",jsonMap);
        jsonObject.put("handlingOpinion",0);
        jsonObject.put("taskId","ee5382fd-9130-11eb-9913-005056c00008");
        request = post("/workFlow/completeTask/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test //查询所有流程
    void getAllFlows() throws Exception {
        JSONObject jsonObject = new JSONObject();

        request = post("/flowsInfo/searchFlowInfo/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test //创建流程
    void createFlow() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowName","我的测试");
        jsonObject.put("flowDescribe","这是我的测试");
        request = post("/flowsInfo/createFlow/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test //编辑流程
    void editFlow() throws Exception {
        request = get("/flowsInfo/editFlow/")
                .contentType(MediaType.APPLICATION_JSON)
                .param("id","4")
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test //通过流程名称修改
    void editByName() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowName","我的测试1");
        request = post("/flowsInfo/updateByProcessName/")
                .contentType(MediaType.APPLICATION_JSON)
//                .param("id","4")
                .content(jsonObject.toJSONString())
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test //通过流程描述修改
    void editByDesc() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowDescribe","这是我的测试1");
        request = post("/flowsInfo/updateByDesc/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(jsonObject.toJSONString())
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
//                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }




}
