package com.tykj.workflowcore.workflow_editer.listener;

import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.api.entity.Parameter;
import com.tykj.workflowcore.workflow_editer.entity.CommandGetValue;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.vo.InvokeRequestVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchVariableStorageVo;
import com.tykj.workflowcore.workflow_editer.service.VariableStorageService;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.engine.*;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ProcessEndListener
 * @packageName com.tykj.workflowcore.workflow_editer.listener
 **/
@Component
public class ProcessEndListener extends AbstractFlowableEngineEventListener {

    @Autowired
    RuntimeService runtimeService;

    @Autowired
    RepositoryService repositoryService;

    @Autowired
    VariableStorageService variableStorageService;

    @Autowired
    ProcessEngineConfigurationImpl processEngineConfiguration;

    @Autowired
    ProcessEngine processEngine;

    @Override
    protected void processCompleted(FlowableEngineEntityEvent event) {
        if (event.getEntity() instanceof ProcessInstance){
            ProcessInstance processInstance = (ProcessInstance) event.getEntity();
            String processInstanceId = processInstance.getProcessInstanceId();
            String processDefinitionId = processInstance.getProcessDefinitionId();
            String flowKey = processDefinitionId.substring(0,processDefinitionId.indexOf(":"));
            List<VariableStorage> variableStorageList = variableStorageService.searchVariableStorageList(new SearchVariableStorageVo(flowKey));
            for (VariableStorage variableStorage : variableStorageList) {
                InvokeRequestVo variableInfo = variableStorage.getInvokeRequest();
                //调用服务接口
                variableInfo.setProcessInstanceId(processInstanceId);
                getApiInvokeParam(variableInfo);
            }
        }

//        throw new ApiException("强行报错");

    }

    @Override
    protected void taskCompleted(FlowableEngineEntityEvent event) {
        super.taskCompleted(event);
    }

    /**
     * 获取调用Api用的参数
     *
     * @param invokeRequestVo 调用服务接口vo
     * @return 调用服务接口实体
     */
    public InvokeRequest getApiInvokeParam(InvokeRequestVo invokeRequestVo) {
        //拿出taskId
        String processInstanceId = invokeRequestVo.getProcessInstanceId();
        List<Parameter> parameterList = invokeRequestVo.getParameterList();
        List<Parameter> newParameterList = new ArrayList<>();
        for (int i = 0; i < parameterList.size(); i++) {
            Parameter parameter = parameterList.get(i);
            if (!StringUtils.isEmpty(parameter.getExp())) {
                //如果是表示式  如：${people}
                parameter.setInstance((Map<String, Object>) getProcessValue(processInstanceId, parameter.getExp()));
            } else {
                Map<String, Object> instance = parameter.getInstance();
                JSONObject newInstance = new JSONObject();
                //遍历param的key
                Set<String> oldInstanceKey = instance.keySet();
                for (String key : oldInstanceKey) {
                    newInstance.put(key, getProcessValue(processInstanceId, (String) instance.get(key)));
                }
                parameter.setInstance(newInstance);
            }
            newParameterList.add(i, parameter);
        }
        invokeRequestVo.setParameterList(newParameterList);
        return JSONObject.parseObject(JSONObject.toJSONString(invokeRequestVo), InvokeRequest.class);
    }

    public Object getProcessValue(String processInstanceId, String exp) {
        // processInstance -> ExecutionEntity
        Expression expression = processEngineConfiguration.getExpressionManager().createExpression(exp);
        ManagementService managementService = processEngine.getManagementService();
        CommandGetValue test = new CommandGetValue(processInstanceId, expression);
        Object o = managementService.executeCommand(test);
        return o;
    }

}
