package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import com.tykj.workflowcore.workflow_editer.entity.vo.FormPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.beans.BeanUtils;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * ClassName:    FormPage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   10:32
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@WorkFlowCoreNoScan
@SQLDelete(sql = "update flows_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@Api("表单页面")
public class FormPage extends BaseEntity {


    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面描述")
    private String pageDesc;

    @ApiModelProperty("模板")
    @Lob
    private String template;

    @ApiModelProperty("页面js")
    @Lob
    private String js;

    @ApiModelProperty("页面css")
    @Lob
    private String css;

    @ApiModelProperty("json描述文件")
    @Lob
    private String descFile;

    @ApiModelProperty("实体类id")
    private String entityId;

    public FormPageVo toEntityVo(){
        FormPageVo inFormPageVo = new FormPageVo();
        BeanUtils.copyProperties(this,inFormPageVo);
        //将string还原成list
        String entityId = this.getEntityId();
        String str[] = entityId.split(",");
        List<String> entityIds = Arrays.asList(str);
        //去重
        List<String> collectIds = entityIds.stream().distinct().collect(Collectors.toList());
        inFormPageVo.setEntityIds(collectIds);
        return inFormPageVo;
    }
}
