package com.tykj.workflowcore.model_layer.utils;



import com.tykj.workflowcore.model_layer.entity.vo.ColumnVO;
import com.tykj.workflowcore.model_layer.entity.vo.TableVO;


import java.util.List;

/**
 * @ClassName CreateTableUtil
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 14:35
 * @Version 1.0
 */
public class CreateTableUtil {
    public static String createTable(TableVO tableVO) {
        //   1sql-type="text" string 转为text文本，2长度超过会自动转换
        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName() + "\" table=\"" + tableVO.getModelName() + "\">\n";

        xmlMapping += " <id name=\"id\" type=\"java.lang.Integer\" length=\"11\" unsaved-value=\"null\">\n" +
                "            <generator class=\"identity\" />\n" +
                "        </id>";
        for (ColumnVO columnVO : dataList) {

            xmlMapping +=
                    " <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName() + "\" length=\"" + columnVO.getFieldLength() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

        }
        xmlMapping += "   </class>\n" +
                "</hibernate-mapping>";
        return xmlMapping;
    }




    public static String getClassName(String aClass) {
        int i = aClass.lastIndexOf(".");
        String substring = aClass.substring(i + 1);
        return substring;
    }

    public static String getTypeName(String aClass) {

        return aClass.replace("class ", "");
    }
}
