/*
 * Decompiled with CFR 0.152.
 */
package com.programmaticallyspeaking.aptdemo;

import com.programmaticallyspeaking.aptdemo.Test;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.yaml.snakeyaml.Yaml;

public class YmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(YmlUtils.class);
    static List<String> fileList = new ArrayList<String>();
    private static String bootstrap_file = "application.yml";
    private static Map<String, String> result = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getYmlByFileName(Test test, String ... keys) {
        result = new HashMap<String, String>();
        InputStream in = null;
        List<String> list = test.getList();
        for (String s : list) {
            try {
                File file = ResourceUtils.getFile((String)s);
                in = new BufferedInputStream(new FileInputStream(file));
                Yaml props = new Yaml();
                Object obj = props.loadAs(in, Map.class);
                Map param = (Map)obj;
                for (Map.Entry entry : param.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (keys.length != 0 && !keys[0].equals(key)) continue;
                    if (val instanceof Map) {
                        YmlUtils.forEachYaml(key, (Map)val, 1, keys);
                        continue;
                    }
                    result.put(key, val.toString());
                }
                Map<String, String> map = result;
                return map;
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getValue(String key) throws FileNotFoundException {
        Map<String, String> map = YmlUtils.getYmlByFileName(null, new String[0]);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static Map<String, String> forEachYaml(String key_str, Map<String, Object> obj, int i, String ... keys) {
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (keys.length > i && !keys[i].equals(key)) continue;
            String str_new = "";
            str_new = StringUtils.isNotEmpty((CharSequence)key_str) ? key_str + "." + key : key;
            if (val instanceof Map) {
                YmlUtils.forEachYaml(str_new, (Map)val, ++i, keys);
                --i;
                continue;
            }
            result.put(str_new, val.toString());
        }
        return result;
    }

    public static String printFiles(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        if (file.isFile() && file.getName().equals("application.yml")) {
            fileList.add(file.getPath());
            return file.getPath();
        }
        for (File listFile : file.listFiles()) {
            YmlUtils.printFiles(listFile);
        }
        return null;
    }
}

