package com.tykj.workflowcore.base.config;

import com.tykj.workflowcore.workflow_editer.listener.ProcessEndListener;
import org.flowable.engine.RuntimeService;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class FlowableGlobListenerConfig
 * @packageName com.tykj.workflowcore.base.config
 **/
@Configuration
public class FlowableGlobListenerConfig  implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private SpringProcessEngineConfiguration configuration;
    @Autowired
    private ProcessEndListener processEndListener;
    @Autowired
    private RuntimeService runtimeService;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        //任务完成全局监听
        //dispatcher.addEventListener(activityCompleteListener, FlowableEngineEventType.TASK_CREATED);
        runtimeService.addEventListener(processEndListener);
    }

}
