package com.tykj.workflowcore.base.config;

import com.google.common.collect.Sets;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.Arrays;
import java.util.Collections;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-04-26
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .produces(Sets.newHashSet("application/json"))
                .consumes(Sets.newHashSet("application/json"))
                .protocols(Sets.newHashSet("https", "http"))
                .apiInfo(apiInfo())
                .forCodeGeneration(true)
                .useDefaultResponseMessages(true)
//                .globalResponseMessage(RequestMethod.GET, getResMsg())
                .select()
                // 指定controller存放的目录路径
//                .apis(RequestHandlerSelectors.withClassAnnotation(AutoDocument.class))
                .paths(PathSelectors.any())
                .build()
                .apiInfo(apiInfo())
                .securitySchemes(Collections.singletonList(securityScheme()))
                .securityContexts(Collections.singletonList(securityContext()));
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                // 文档标题
                .title("装备系统接口文档")
                // 文档描述
                .description("装备系统的接口文档与测试页面")
                .termsOfServiceUrl("git地址待更新")
                .version("v1")
                .contact(new Contact("efs", "git", "ty@example.com"))
                .build();
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder()
                .securityReferences(Collections.singletonList(new SecurityReference("spring_oauth", scopes())))
                .forPaths(PathSelectors.any())
                .build();
    }

    private SecurityScheme securityScheme() {
        GrantType grantType = new ResourceOwnerPasswordCredentialsGrant("/user/login");

        return new OAuthBuilder()
                .name("spring_oauth")
                .grantTypes(Collections.singletonList(grantType))
                .scopes(Arrays.asList(scopes()))
                .build();
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[]{
                new AuthorizationScope("all", "All scope is trusted!")
        };
    }
//    private ArrayList<ResponseMessage> getResMsg() {
//        return newArrayList(new ResponseMessageBuilder()
//                        .code(500)
//                        .message("服务器内部发生了某种错误")
//                        .responseModel(new ModelRef("Error"))
//                        .build(),
//                new ResponseMessageBuilder()
//                        .code(404)
//                        .message("用户发出的请求针对的是不存在的记录，服务器没有进行操作")
//                        .responseModel(new ModelRef("Exception"))
//                        .build(),
//                new ResponseMessageBuilder()
//                        .code(406)
//                        .message("用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）")
//                        .responseModel(new ModelRef("Exception"))
//                        .build(),
//                new ResponseMessageBuilder()
//                        .code(501)
//                        .message("不支持的HTTP请求，请检查HTTP TYPE与资源路径是否正确")
//                        .responseModel(new ModelRef("Exception"))
//                        .build());
//    }

}
