package com.tykj.workflowcore.base.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.*;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.io.File;


/**
 * @author zsp
 * @version V1.0
 * @class WebMvcConfig
 * @packageName com.example.personnelmanager.common.config
 * @data 2020/6/11
 **/

@Configuration
public class WebMvcConfig  implements WebMvcConfigurer  {

    @Bean
    public WebMvcConfigurer corsConfigurer() {

        return new WebMvcConfigurer() {
            @Override
            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**")
                        .allowedOriginPatterns("*")
                        .allowCredentials(true)
                        .allowedMethods("GET", "POST", "DELETE", "PUT", "PATCH")
                        .maxAge(3600);
            }

            @Override
            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler("/workflow/xml/**")
                        .addResourceLocations("file:" + System.getProperty("user.dir") + File.separator+"xml"+File.separator);
//                        .addResourceLocations("file:" + System.getProperty("user.dir") +"\\xml\\");
                registry.addResourceHandler("/xml/**")
                        .addResourceLocations("file:" + System.getProperty("user.dir") + File.separator+"xml"+File.separator);
//                        .addResourceLocations("file:" + System.getProperty("user.dir") + "\\xml\\");
                registry.addResourceHandler("/**")
                        .addResourceLocations("classpath:/workflow/");
                registry.addResourceHandler("/swagger-ui.html").addResourceLocations("classpath:/META-INF/resources/");
                registry.addResourceHandler("/webjars/**").addResourceLocations("classpath:/META-INF/resources/webjars/");
            }
        };
    }

}
