package com.tykj.workflowcore.base.config;

import org.flowable.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import java.io.File;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class Comm
 * @packageName com.tykj.workflwcore
 **/
@Configuration
@ComponentScan(
        basePackages = {"com.tykj.workflowcore.*"}
)
@EnableJpaRepositories(basePackages = {
        "com.tykj.workflowcore.model.repository",
        "com.tykj.workflowcore.workflow_editer.dao",
        "com.tykj.workflowcore.user.dao"
})
public class WorkflowCoreRunner implements CommandLineRunner {


    @Autowired
    RuntimeService runtimeService;

    @Override
    public void run(String... args) {
        System.out.println("核心成功启动");
        //创建xml文件夹  如果不存在的话
        createXmlMkdir();

    }

    public void createXmlMkdir(){
        File file = new File(System.getProperty("user.dir")+"\\xml");
        if (!file.exists()){
            file.mkdir();
        }
    }


//    //通过loader加载所有类
//    private List<Class<?>> loadClassByLoader(ClassLoader load) {
//        List<Class<?>> classes = new ArrayList<>();
//        try {
//            Enumeration<URL> urls = load.getResources("");
//            //放所有类型
//            while (urls.hasMoreElements()) {
//                URL url = urls.nextElement();
//                //文件类型（其实是文件夹）
//                if (url.getProtocol().equals("file")) {
//                    loadClassByPath(null, url.getPath(), classes, load);
//                }
//            }
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return classes;
//    }
//
//    //通过文件路径加载所有类 root 主要用来替换path中前缀（除包路径以外的路径）
//    private void loadClassByPath(String root, String path, List<Class<?>> list, ClassLoader load) {
//        File f = new File(path);
//        if (root == null) root = f.getPath();
//        //判断是否是class文件
//        if (f.isFile() && f.getName().matches("^.*\\.class$")) {
//            try {
//                String classPath = f.getPath();
//                //截取出className 将路径分割符替换为.（windows是\ linux、mac是/）
//                String className = classPath.substring(root.length() + 1, classPath.length() - 6).replace('/', '.').replace('\\', '.');
//                list.add(load.loadClass(className));
//            } catch (Exception ex) {
//                ex.printStackTrace();
//            }
//        } else {
//            File[] fs = f.listFiles();
//            if (fs == null) return;
//            for (File file : fs) {
//                loadClassByPath(root, file.getPath(), list, load);
//            }
//        }
//    }




}
