package com.tykj.workflowcore.model.controller;

import com.google.common.collect.ImmutableMap;
import com.tykj.workflowcore.model.entity.TableInfoEx;
import com.tykj.workflowcore.model.service.TableInfoExService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Api(tags = "聚合模型接口")
@CrossOrigin
@RequestMapping("/tableinfo/ex")
@RestController
public class TableInfoExController {

    @Autowired
    private TableInfoExService tableInfoExService;

    @ApiOperation(value = "新增聚合模型")
    @PostMapping
    public ResponseEntity save(@RequestBody TableInfoEx tableInfoEx) {
        tableInfoExService.save(tableInfoEx);
        return ResponseEntity.ok(ImmutableMap.of("message","新增成功"));
    }

    @ApiOperation(value = "修改聚合模型")
    @PutMapping
    public ResponseEntity update(@RequestBody TableInfoEx tableInfoEx) {
        tableInfoExService. update(tableInfoEx);
        return ResponseEntity.ok(ImmutableMap.of("message","修改成功"));
    }

    @ApiOperation(value = "查询所有聚合模型")
    @GetMapping
    public ResponseEntity findAll() {
        List<TableInfoEx> tableInfoExes = tableInfoExService.findAll();
        return ResponseEntity.ok(ImmutableMap.of("data",tableInfoExes));
    }

    @ApiOperation(value = "根据process查询")
    @GetMapping("/processKey/{processKey}")
    public ResponseEntity findByProcessKey(@PathVariable String processKey) {
        List<TableInfoEx> tableInfoExes = tableInfoExService.findByProcessKey(processKey);
        return ResponseEntity.ok(ImmutableMap.of("data",tableInfoExes));
    }

    @ApiOperation(value = "根据process查询 以Json形式返回")
    @GetMapping("/processKey/json/{processKey}")
    public ResponseEntity findByProcessKeyInMap(@PathVariable String processKey) {
        List<Map<String, Map<String, Object>>> tableInfoExes = tableInfoExService.findByProcessKeyInMap(processKey);
        return ResponseEntity.ok(ImmutableMap.of("data",tableInfoExes));
    }

    @ApiOperation(value = "根据名称删除聚合模型")
    @DeleteMapping("/{name}")
    public ResponseEntity deleteByName(@PathVariable String name) {
        tableInfoExService.deleteByName(name);
        return ResponseEntity.ok(ImmutableMap.of("message", "删除成功"));
    }

}
