package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.List;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class Bind {

    @Id
    @JsonIgnore
    private Integer id;

    @ApiModelProperty(value = "绑定的基础对象的名称", position = 1)
    private String name;

    @ApiModelProperty(value = "绑定的基础对象的版本号", readOnly = true, position = 2)
    private Integer version;

    @ApiModelProperty(value = "绑定的基础对象的别名", position = 3)
    private String alias;

    @ApiModelProperty(value = "绑定的基础对象的描述", position = 4)
    private String description;

    @ApiModelProperty(value = "是否为复数 true/false", position = 5)
    private Boolean isComplex;

    @ApiModelProperty(value = "字段信息", readOnly = true, position = 7)
    @Transient
    private List<ColumnInfo> columnInfos;

    @JsonIgnore
    private Integer tableInfoExId;

    @JsonIgnore
    private Integer parentId;

    @ApiModelProperty(value = "下级基础对象的绑定信息", position = 8)
    @Transient
    private List<Bind> children;

}
