package com.tykj.workflowcore.model.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Accessors(chain = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class TableInfoEx {

    @Id
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty(value = "创建时间", position = 1)
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date createdTime;

    @ApiModelProperty(value = "修改时间",position = 2)
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm")
    private Date updatedTime;

    @ApiModelProperty(value = "聚合对象名", position = 3)
    private String name;

    @ApiModelProperty(value = "别名", position = 4)
    private String alias;

    @ApiModelProperty(value = "描述", position = 5)
    private String description;

    @ApiModelProperty(value = "工作流用预留字段", position = 6)
    private String processKey;

    @ApiModelProperty(value = "版本号", readOnly = true, position = 7)
    private Integer version;

    @ApiModelProperty(value = "绑定信息", position = 8)
    @Transient
    private List<Bind> binds;

}
