package com.tykj.workflowcore.model.repository;

import com.tykj.workflowcore.model.entity.Bind;
import org.springframework.data.jpa.repository.JpaRepository;

import javax.transaction.Transactional;
import java.util.List;

public interface BindRepository extends JpaRepository<Bind, Integer> {

    List<Bind> findByTableInfoExId(Integer tableInfoExId);

    List<Bind> findByTableInfoExIdAndParentId(Integer tableInfoExId, Integer parentId);

    List<Bind> findByName(String name);

    @Transactional
    void deleteAllByTableInfoExId(Integer tableInfoExId);

    boolean existsByName(String name);

}
