package com.tykj.workflowcore.user.controller;

import com.sun.istack.NotNull;
import com.tykj.workflowcore.user.pojo.Authority;
import com.tykj.workflowcore.user.pojo.LogContent;
import com.tykj.workflowcore.user.pojo.vo.ServerResponse;
import com.tykj.workflowcore.user.pojo.vo.uservo.AuthorityLogVo;
import com.tykj.workflowcore.user.pojo.vo.uservo.AuthorityNameVo;
import com.tykj.workflowcore.user.pojo.vo.uservo.AuthorityTypeVo;
import com.tykj.workflowcore.user.pojo.vo.uservo.AuthorityVo;
import com.tykj.workflowcore.user.service.AuthorityService;
import com.tykj.workflowcore.user.service.LogContentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/authority")
@Api(tags = "权限管理")
public class AuthorityController {
    @Autowired
    private AuthorityService authorityService;
    @Autowired
    private LogContentService logContentService;

    @ApiOperation("新增权限")
    @PostMapping("/add")
    public ServerResponse add(@Validated @RequestBody AuthorityVo authorityVo){
        LogContent logContent = new LogContent();
        logContent.setOperator(authorityVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("新增权限");

        Authority authority = authorityService.save(authorityVo.getAuthority());
        if (authority != null){
            logContent.setResult("操作成功");
            logContentService.save(logContent);
            return ServerResponse.ok(authority);
        }
        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("新增权限失败");
    }

    @ApiOperation("修改权限信息")
    @PostMapping("/update")
    public ServerResponse update(@Validated @RequestBody AuthorityVo authorityVo) {
        LogContent logContent = new LogContent();
        logContent.setOperator(authorityVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("修改权限信息");

        Authority authority = authorityService.update(authorityVo.getAuthority());
        if (authority != null){
            logContent.setResult("操作成功");
            logContentService.save(logContent);
            return ServerResponse.ok(authority);
        }

        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("新增权限失败");
    }


    @ApiOperation("根据id 查看权限详情")
    @PostMapping("/findById")
    public ServerResponse findById(@Validated @RequestBody AuthorityLogVo authorityLogVo) {
        Authority authority = authorityService.findById(authorityLogVo.getId());

        if (authority != null) {
            return ServerResponse.ok(authority);
        }
        return ServerResponse.error("未查询到该权限详情");
    }


    @ApiOperation("删除权限")
    @DeleteMapping("/delete")
    public ServerResponse delete(@NotNull @RequestBody AuthorityLogVo authorityLogVo){
        LogContent logContent = new LogContent();
        logContent.setOperator(authorityLogVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("删除权限");
        try{
        authorityService.delete(authorityLogVo.getId());
        logContent.setResult("操作成功");
        logContentService.save(logContent);
        return ServerResponse.ok("删除成功");
        }catch (Exception e){
            logContent.setResult("操作失败");
            logContentService.save(logContent);

            return ServerResponse.error("删除失败");
        }
    }

    @ApiOperation("查看所有权限")
    @GetMapping("/findAll/{loginer}")
    public ServerResponse findAll(@NotNull @PathVariable String loginer) {
        List<Authority> authorityList = authorityService.findAll();
        if (authorityList != null){
            return ServerResponse.ok(authorityList);
        }
        return ServerResponse.error("查看失败");

    }

    @ApiOperation("根据类型 查看权限详情")
    @PostMapping("/findByType")
    public ServerResponse findById(@Validated @RequestBody AuthorityTypeVo authorityTypeVo) {
        List<Authority> authorityList = authorityService.findByType(authorityTypeVo.getType());
        if (authorityList != null) {
            return ServerResponse.ok(authorityList);
        }
        return ServerResponse.error("未查询到该类型权限详情");
    }


    @ApiOperation("根据名称 查看权限详情")
    @PostMapping("/findByName")
    public ServerResponse findByName(@Validated @RequestBody AuthorityNameVo authorityNameVo) {
        String name = authorityNameVo.getName();
        List<Authority> authorityList = new ArrayList<>();
        if (name==null){
            authorityList = authorityService.findAll();
        }
        authorityList = authorityService.findByNameLike(authorityNameVo.getName());
        if (authorityList!=null){
            return ServerResponse.ok(authorityList);
        }
        return ServerResponse.error("未查询到权限");
    }


}
