package com.tykj.workflowcore.user.controller;

import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import com.tykj.workflowcore.user.pojo.vo.ServerResponse;
import com.tykj.workflowcore.user.service.OrgUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/org")
@Api(tags = "组织人员")
public class OrgUserController {
    @Autowired
    OrgUser orgTest;
    @ApiOperation("查询全部组织架构")
    @GetMapping("/findAll")
    public ServerResponse findAll(@RequestParam(required = false) String name){
        List<OrganizationVo> organizationVos = orgTest.findOrgAndUser(name);
        if (organizationVos != null){
            return ServerResponse.ok(organizationVos);
        }
        return ServerResponse.error("查看组织架构失败");
    }


    @ApiOperation("根据人员名字查询组织架构")
    @GetMapping("/findByName")
    public ServerResponse findByName(@RequestParam(required = false) String name){
        List<OrganizationVo> organizationVos = orgTest.findByUserName(name);
        if (organizationVos != null){
            return ServerResponse.ok(organizationVos);
        }
        return ServerResponse.error("查看组织架构失败");
    }
}
