package com.tykj.workflowcore.user.dao;


import com.tykj.workflowcore.user.pojo.UserAuthority;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UserAuthorityDao  extends JpaRepository<UserAuthority, Integer>, JpaSpecificationExecutor<UserAuthority> {

    List<UserAuthority> findByUid(String uid);

    UserAuthority findByUidAndAuthorityId(String uid, Integer authorityId);

    List<UserAuthority> findByAuthorityId(Integer authorityId);
}
