package com.tykj.workflowcore.user.pojo;

import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.ArrayList;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("组织架构")
public class Organization {
    @Id
    @ApiModelProperty(value = "机构组织id")
    private Integer id;

    @ApiModelProperty(value = "机构编码")
    private String code;

    @ApiModelProperty(value = "机构名称")
    private String organizationName;

    @ApiModelProperty(value = "上级id")
    private Integer pid = 0;

    @ApiModelProperty(value = "上级机构名称")
    private String pname;

    @ApiModelProperty(value = "组织介绍")
    private String description;

    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    @ApiModelProperty(value = "规范名称")
    private String specificationName;


    @ApiModelProperty(value = "规范编码")
    private String specificationCode;

    //private List<Organization> children;
    public OrganizationVo toVo(){
        return new OrganizationVo(id,code,organizationName, new ArrayList(),new ArrayList<>());
    }

}
