package com.tykj.workflowcore.user.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("存储私密钥")
@Table
public class StorageKey {

    @Id
    @ApiModelProperty(value = "权限id")
    private Integer id;

    @Lob
    @ApiModelProperty(value = "应用签名公钥，由系统生成。公钥发放给应用的负责人，用于对JWT验签")
    private String signPublicKey ;

    @Lob
    @ApiModelProperty(value = "应用签名私钥，由系统生成。私钥用于对JWT进行签名")
    private String signPrivateKey ;

    @Lob
    @ApiModelProperty(value = "应用jwt加密公钥，由系统生成。用于对JWT加密")
    private String rsaPublicKey ;

    @Lob
    @ApiModelProperty(value = "应用jwt解密私钥，由系统生成。私钥发放给应用的负责人，用于对JWT解密")
    private String rsaPrivateKey ;
}
