package com.tykj.workflowcore.user.pojo.vo;

import com.tykj.workflowcore.user.pojo.User;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString(exclude = "childNodes")
public class OrganizationVo {
    @ApiModelProperty(value = "组织id")
    private Integer id ;

    @ApiModelProperty(value = "机构编码")
    private String code;

    @ApiModelProperty(value = "组织名称")
    private String  organizationName;

    private List<User> users;

    /*@ApiModelProperty(value = "用户列表")
    private List<User> userList;
*/
    @ApiModelProperty(value = "子级名称")
    public List<OrganizationVo> childNodes = new ArrayList<>(4);


    public  void addChildNode(OrganizationVo organizationVo){
        childNodes.add(organizationVo);
    }

}
