package com.tykj.workflowcore.user.service;

import com.tykj.workflowcore.user.pojo.Organization;
import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

@Component
public class OrgUser {
    @Autowired
    OrganizationService organizationService;
    @Autowired
    UserService userService;

    /**
     * 根据人名字查询所有组织机构树
     * @param name 人员姓名
     * @return 带人员的组织机构树
     */
    public List<OrganizationVo> findOrgAndUser(String name){
        List<Organization> organizationList = organizationService.findAll();
        List<OrganizationVo> organizationVos = organizationService.find(organizationList);
        List<User> users;
        if (name == null){
            users = userService.findAll();
        }else {
            users = userService.findByRealName(name);
        }
        if (users == null || users.size() == 0){
            return new ArrayList<>();
        }
        getChild(organizationVos, users);
        return organizationVos;
    }

    /**
     * 根据人名字查询只有人的组织机构树
     * @param name 人员姓名
     * @return 带人员的组织机构树
     */
    public List<OrganizationVo> findByUserName(String name){
        List<Organization> organizationList = organizationService.findAll();
        List<Organization> organizations = new ArrayList<>();
        List<User> users;
        if (name != null){
            users = userService.findByRealName(name);
            if (users != null && users.size() > 0){
                for (User user : users){
                    List<Organization> list = organizationList.stream()
                            .filter(organization -> Objects.equals(user.getOrganizationId(), organization.getId()))
                            .collect(Collectors.toList());
                    if (list.size() > 0){
                        organizations.add(list.get(0));
                        findOrgFid(list.get(0).getPid(), organizationList, organizations);
                    }
                }
            }else {
                return new ArrayList<>();
            }
        }else {
            users = userService.findAll();
            organizations = organizationList;
        }
        List<OrganizationVo> organizationVos = organizationService.find(organizations);
        getChild(organizationVos, users);
        return organizationVos;

    }

    /**
     * 找到机构所有的父级机构
     * @param orgId 需要找父级机构的机构编号
     * @param o 所有机构列表
     * @param re 返回机构列表
     */
    private void findOrgFid(int orgId, List<Organization> o, List<Organization> re){
        List<Organization> orgs = o.stream()
                .filter(organization -> Objects.equals(orgId, organization.getId()))
                .collect(Collectors.toList());
        if (orgs.size() > 0){
            re.addAll(orgs);
            findOrgFid(orgs.get(0).getPid(), o, re);
        }
    }

    /**
     * 把人员放到组织机构树中
     * @param vos 组织机构树列表
     * @param users 人员列表
     */
    private void getChild(List<OrganizationVo> vos, List<User> users) {
        for (OrganizationVo organizationVo : vos) {
            List<User> users1 = users.stream().filter(user -> Objects.equals(organizationVo.getId(), user.getOrganizationId()))
                    .collect(Collectors.toList());
            organizationVo.setUsers(users1);
            if (organizationVo.getChildNodes().size() > 0) {
                getChild(organizationVo.getChildNodes(), users);
            }
        }
    }

}
