package com.tykj.workflowcore.user.service;

import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.UserAuthority;
import com.tykj.workflowcore.user.pojo.vo.PageResponse;

import java.util.List;

public interface UserAuthorityService {

    List<UserAuthority> findByUid(String uid);

    List<Integer> findAuthByUid(String uid);

    UserAuthority findByUidAndAuthorityId(String uid, Integer authorityId);

    void delete(UserAuthority userAuthority);

    UserAuthority save(UserAuthority userAuthority);

    PageResponse<User> findByAuthId(Integer authId, int page, int size);

    void delete(Integer authId, String uId);

    List<User> findByAuthId(Integer authId);

    /**
     * 根据用户id 查找该用户所拥有App权限的id
     * @param uid
     * @return
     */
    String findAppByUserId(String uid);





}
