package com.tykj.workflowcore.user.service;

import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.UserDetail;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface UserService {
    /**
     * 通過用戶名查詢用戶
     * @param username
     * @return
     */
    UserDetail selectByUserName(String username);
    /**
     * 根据用户查询SpringSecurity的用户实体类
     * @param username
     * @return
     */
    UserDetail getUserDetail(String username);
    /**
     * 添加用戶
     * @param user
     * @return
     */
    User addUser(User user);


    /**
     * 修改用户信息
     * @param user
     * @return
     */
    User update(User user);

    /**
     * 根据用户id 逻辑删除用户，将用户状态设置为已删除，页面不展示该用户
     * @param id
     * @return
     */
    User delete(String id);

    /**
     * 根据用户id查询用户详情
     * @param id
     * @return
     */
    User findById(String id);

    /**
     * 根据用户名 模糊查询
     * @param name
     * @return
     */
    List<User> findByNameLike(String name);



    /**
     * 给用户解锁
     * @param id 用户id
     */
    Integer unlock(String id);


    /**
     * 用户锁死
     * @param id 用户id
     */
    Integer locked(String id);


    /**
     * 重置用户密码
     * @param id 用户id
     */
    User resetPassword(String id);


    String uploadImage(MultipartFile file,String loginer) throws IOException;


    List<User> findAll();

    List<User> findAllByOrganizationId(Integer organizationId);

    List<User> findByCustomerLeverAndDelStatus(String customerLever);

    List<User> findByRealName(String realName);
}
