package com.tykj.workflowcore.user.service.impl;

import com.tykj.workflowcore.user.dao.UserDao;
import com.tykj.workflowcore.user.pojo.User;
import com.tykj.workflowcore.user.pojo.UserDetail;
import com.tykj.workflowcore.user.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.*;

@Service
public class UserServiceImpl implements UserService {
    @Value("/home/tykj/Desktop/icon/")
    private String path;

    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    UserDao userDao;

    @Override
    public UserDetail selectByUserName(String username) {
        if (username!=null){
            User byUsername = userDao.findByUsername(username);
            if (byUsername==null){
                return null;
            }
            UserDetail userDetail = new UserDetail();
            BeanUtils.copyProperties(byUsername,userDetail);
            //判断用户是否被删除
            if (userDetail.getDelStatus()==2){
                return null;
            }
            return  userDetail;
        }
        return null;
    }

    @Override
    public UserDetail getUserDetail(String username) {
        User user = selectByUserName(username);
        System.out.println("登录用户名:"+username);
        if (user!=null){
            UserDetail userDetail = new UserDetail();
            BeanUtils.copyProperties(user,userDetail);
            return userDetail;
        }else {
            throw new UsernameNotFoundException("该用户名不存在");
        }
    }


    @Override
    public User addUser(User user) {
        return userDao.save(user);
    }

    @Override
    public User update(User user) {
        return userDao.save(user);
    }

    @Override
    public User delete(String id) {
        User user = userDao.findById(id).get();
        user.setDelStatus(2);
        return userDao.save(user);
    }

    @Override
    public User findById(String id) {
        User user = userDao.findByIdAndDelStatus(id, 1);
        //return userDao.findById(id).get();
        return user;
    }

    @Override
    public List<User> findByNameLike(String name) {
        List<User> userList = userDao.findByDelStatusAndRealNameLike(1, "%" + name + "%");
        return userList;
    }

    @Override
    public Integer unlock(String id) {
        User user = userDao.findById(id).get();
        user.setLocked(0);
        User user1 = userDao.save(user);
        return user1.getLocked();
    }

    @Override
    public Integer locked(String id) {
        User user = userDao.findById(id).get();
        user.setLocked(1);
        User user1 = userDao.save(user);
        return user1.getLocked();

    }


    @Override
    public User resetPassword(String id) {
        User user = userDao.findById(id).get();
        user.setPassword(passwordEncoder.encode("qwer1234"));
        if (userDao.save(user) != null){
            return user;
        }
        return null;
    }


    @Override
    public String uploadImage(MultipartFile file,String loginer) throws IOException {

        //获取文件全名（名称+后缀）
        String fileName = file.getOriginalFilename();
        //获取文件后缀
        String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));

        //获取文件名
        String fileName1 = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("\\") + 1);
        String fileNewName = fileName1.substring(0, fileName1.lastIndexOf("."));

        fileName = UUID.randomUUID() + suffixName;
        //指定本地存入路径
        file.transferTo(new File(path + fileName));

        return fileName;
    }

    @Override
    public List<User> findAll() {
        List<User> userList = userDao.findAllByDelStatus(1);
        if (userList!=null){
            return userList;
        }
        return null;
    }

    @Override
    public List<User> findAllByOrganizationId(Integer organizationId) {
        List<User> userList = userDao.findAllByOrganizationIdAndDelStatus(organizationId,1);
        if (userList!=null){
            return userList;
        }
        return null;
    }

    @Override
    public List<User> findByCustomerLeverAndDelStatus(String customerLever) {

        List<User> userList = userDao.findByCustomerLeverAndDelStatus(customerLever, 1);
        if (userList!= null){
            return userList;
        }
        return null;

    }

    @Override
    public List<User> findByRealName(String realName) {
        List<User> userList = userDao.findByDelStatusAndRealNameLike(1,"%" + realName + "%");
        if (userList!=null){
            for (User user : userList) {
                System.out.println("_________________");
                System.out.println("======"+user);
            }
            return userList;
        }
        return null;
    }
}
