package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.xml.stream.XMLStreamException;
import java.io.IOException;
import java.util.List;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api(tags = "流程管理接口")
@RequestMapping("/flowsInfo")
public class FlowsInfoController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;
    
    @Autowired
    private RuntimeService runtimeService;


    @PostMapping("/searchAllFlowInfo")
    @ApiOperation(value = "查询所有流程信息")
    public Page<FlowsInfo> searchAllFlowInfo(@RequestBody SearchAllFlowInfoVo searchAllFlowInfoVo){
        return flowInfoService.searchAllFlowInfo(searchAllFlowInfoVo);
    }

    @PostMapping("/searchFlowInfo")
    @ApiOperation(value = "查询可发起流程信息")
    public Page<FlowsInfo> searchFlowInfo(@RequestBody SearchFlowInfoVo searchFlowInfoVo){
        return flowInfoService.searchFlowInfo(searchFlowInfoVo);
    }

    @PostMapping("/upLoadFile")
    @ApiOperation(value = "上传文件")
    public String upLoadFile(@RequestParam("file") MultipartFile file){
        return  workFlowService.upLoadFile(file);
    }

    @GetMapping("/editFlow")
    @ApiOperation(value = "根据ID查询流程详情")
    public ResponseEntity editFlow(Integer id){
            return  ResultUtil.success(flowInfoService.editFlow(id),"查询成功");
    }


    @PostMapping("/saveXml")
    @ApiOperation(value = "保存xml以及其他流程信息")
    public ResponseEntity saveXml(@RequestBody FlowsInfoVo flowsInfoVo) throws IOException, XMLStreamException {
        //验证一下是否为更新，如果为更新的话，先判断该流程是否存在未运行完成的流程，如果的话则拒绝更新
        List<ProcessInstance> list = runtimeService.createProcessInstanceQuery().processDefinitionKey(flowsInfoVo.getFlowKey()).list();
        if (list.size()>0){
            throw new ApiException("存在正在运行的流程实例，请先将正在运行的流程实例全部完结后才可以进行修改");
        }
        //保存节点信息
//        nodeInfoService.saveNodeInfoList(flowsInfoVo.getNodeInfoList());
        //保存xml信息
        workFlowService.flowXml(flowsInfoVo);
        return ResultUtil.success("文件保存成功");
    }



    @PostMapping("/updateByProcessName")
    @ApiOperation(value = "通过流程名称修改")
    public ResponseEntity updateByProcessName(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.updateByProcessName(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowName(),"流程修改成功");
    }

    @PostMapping("/updateByDesc")
    @ApiOperation(value = "通过流程描述修改")
    public ResponseEntity updateByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {
        FlowsInfo flowsInfo = flowInfoService.findByDesc(flowsInfoVo);
        return ResultUtil.success(flowsInfo.getFlowDescribe(),"流程修改成功");
    }

    @PostMapping("/createFlow")
    @ApiOperation("创建流程")
    public ResponseEntity createFlow(@RequestBody FlowsInfoVo flowsInfovo){
        return ResultUtil.success(workFlowService.createFlow(flowsInfovo.toEntity()),"流程创建成功");
    }

    @PostMapping("/updateFlowCandidate")
    @ApiOperation("更新流程可发起人、")
    public ResponseEntity updateFlowCandidate(@RequestBody FlowsInfoVo flowsInfovo){
        return ResultUtil.success(flowInfoService.updateCandidate(flowsInfovo.getFlowKey(),flowsInfovo.getCandidateUsers(),flowsInfovo.getCandidateRoleDetail()),"流程创建成功");
    }



}
