package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.entity.vo.FormPageVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.PageFormPageVo;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


/**
 * ClassName:    FormPageController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/3   13:40
 *
 * @Author: zsp
 */
@RestController()
@RequestMapping("/formPage")
@Api(tags = "页面管理接口")
public class FormPageController {

    @Autowired
    private FormPageService formPageService;

    @ApiOperation("保存页面")
    @PostMapping("/savePage")
    public ResponseEntity savePage(@RequestBody FormPageVo inFormPageVo){
        if (StringUtils.isEmpty(inFormPageVo.getProcessKey())){
            throw new ApiException("processKey不能为空");
        }
        if (inFormPageVo.getId() == null){
            Integer pageId = formPageService.savePage(inFormPageVo);
            return ResultUtil.success(pageId,"页面保存成功");
        }else {
            //修改
            FormPage formPage = inFormPageVo.toEntity();
            formPageService.update(formPage);
            return ResultUtil.success(inFormPageVo.getId(),"页面保存成功");
        }
    }
    @ApiOperation("回显页面")
    @GetMapping("/EchoPage")
    public FormPage EchoPage(Integer id){
        return  formPageService.getPage(id);
    }

    @ApiOperation("查看页面")
    @PostMapping("/findPages")
    public ResponseEntity findPages(@RequestBody PageFormPageVo pageFormPageVo){

        return  ResultUtil.success(formPageService.getAllPages(pageFormPageVo),"查询成功");
    }

    @ApiOperation("查看列表")
    @PostMapping("/findList")
    public ResponseEntity findList(@RequestBody PageFormPageVo pageFormPageVo){
        return  ResultUtil.success(formPageService.getAllList(pageFormPageVo),"查询成功");
    }

    @ApiOperation("删除页面")
    @DeleteMapping("deletePage")
    public ResponseEntity deletePage(Integer id){
        formPageService.deletePage(id);
        return ResultUtil.success("删除页面成功");
    }

}
