package com.tykj.workflowcore.workflow_editer.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.workflow_editer.entity.vo.ParameterVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Lob;
import java.util.List;

/**
 * ClassName:    VariableStorage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   10:03
 *
 * @Author: zsp
 */
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Data
public class VariableStorage extends BaseEntity {

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty("流程主键")
    private String activityId;

    @ApiModelProperty("调用类名")
    private String className;

    @ApiModelProperty("调用方法")
    private String name;

    @ApiModelProperty("方法描述")
    private String description;

    @Lob
    @ApiModelProperty("详情json")
    private String params;

    public List<ParameterVo> getParams() {
        return JSON.parseObject(params,new TypeReference<List<ParameterVo>>(){});
    }
}
