package com.tykj.workflowcore.workflow_editer.entity.vo;

import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * ClassName:    FlowInfoVo
 * Package:    com.tykj.vo
 * Description:
 * Datetime:    2021/3/1   9:54
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlowsInfoVo {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("流程名称")
    private String flowName;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty(value = "部署状态",notes = "0 已部署，1 未部署")
    private Integer state = 1;

    @ApiModelProperty("流程描述")
    private String flowDescribe;

    @ApiModelProperty("流程XML")
    private String fileXml;

    @ApiModelProperty("流程可发起用户")
    private List<String> candidateUsers ;

    @ApiModelProperty("流程可发起用户组")
    private List<CandidateRoleDetailVo> candidateRoleDetail;

    public FlowsInfo toEntity(){
        FlowsInfo flowsInfo = new FlowsInfo();
        BeanUtils.copyProperties(this,flowsInfo);
        return flowsInfo;
    }

    public FlowsInfo toEntity(FlowsInfo oldFlowsInfo){
        if (!StringUtils.isEmpty(flowName)){
            oldFlowsInfo.setFlowName(flowName);
        }
        if (!StringUtils.isEmpty(flowDescribe)){
            oldFlowsInfo.setFlowDescribe(flowDescribe);
        }
        return oldFlowsInfo;
    }
}
