package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.user.controller.OrganizationController;
import com.tykj.workflowcore.user.pojo.Organization;
import com.tykj.workflowcore.user.pojo.vo.OrganizationVo;
import com.tykj.workflowcore.user.pojo.vo.ServerResponse;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRole;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowRoleType;
import com.tykj.workflowcore.workflow_editer.entity.WorkFlowUser;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DefaultUserSerbiveImpl
 * @packageName com.tykj.workflowcore.workflow_editer.service.impl
 **/
@Service
@Order
public class DefaultUserServiceImpl implements UserService {

    @Autowired
    OrganizationController organizationController;

    @Override
    public WorkFlowUser getCurrentUser() {
        WorkFlowUser workFlowUser = new WorkFlowUser();
        workFlowUser.setId("0");
        workFlowUser.setUserName("张0");
        return workFlowUser;
    }

    @Override
    public List<WorkFlowUser> getAllUser() {
        List<WorkFlowUser> workFlowUsers = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            WorkFlowUser workFlowUser = new WorkFlowUser();
            workFlowUser.setUserName("张"+i);
            workFlowUser.setId("i"+i);
            workFlowUsers.add(workFlowUser);
        }
        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRole> getAllRole(String roleType) {
        List<WorkFlowRole> workFlowUsers = new ArrayList<>();
        if (roleType.equals("organization")){
            List<OrganizationVo> data = (List<OrganizationVo>) organizationController.findByName(null).getData();
            List<WorkFlowRole> workFlowRoles = changeOrgToWorkFlowRole(data);
            workFlowUsers.addAll(workFlowRoles);
        }else {
            workFlowUsers.add(new WorkFlowRole("管理员","role","1",null));
            workFlowUsers.add(new WorkFlowRole("普通用户","role","2",null));
            workFlowUsers.add(new WorkFlowRole("运维人员","role","3",null));
        }

        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRoleType> getRoleType() {
        List<WorkFlowRoleType> workFlowRoleTypes = new ArrayList<>();
        workFlowRoleTypes.add(new WorkFlowRoleType("组织架构","organization"));
        workFlowRoleTypes.add(new WorkFlowRoleType("角色","role"));
        return workFlowRoleTypes;
    }

    private List<WorkFlowRole> changeOrgToWorkFlowRole(List<OrganizationVo> organizationList) {
        List<WorkFlowRole> workFlowRoles = new ArrayList<>();
        for (OrganizationVo organization : organizationList) {
            WorkFlowRole workFlowRole = new WorkFlowRole();
            if (organization.getChildNodes()!=null&&organization.getChildNodes().size()>0){
                workFlowRole.setChildNodes(changeOrgToWorkFlowRole(organization.getChildNodes()));
            }
            workFlowRole.setName(organization.getOrganizationName());
            workFlowRole.setRoleId(organization.getCode());
            workFlowRole.setRoleType("organization");
            workFlowRoles.add(workFlowRole);
        }
        return workFlowRoles;
    }
}
