package com.tykj.workflowcore.workflow_editer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.workflow_editer.dao.FlowsInfoMapper;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.CandidateRoleDetailVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.FlowsInfoVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchAllFlowInfoVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchFlowInfoVo;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import lombok.extern.slf4j.Slf4j;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.*;
import java.util.stream.Collectors;

/**
 * ClassName:    FlowInfoServiceImpl
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/24   10:15
 *
 * @Author: zsp
 */
@Service
@Slf4j
public class FlowInfoServiceImpl implements FlowInfoService {

    @Autowired
    private FlowsInfoMapper flowsInfoMapper;

    @Autowired
    private RepositoryService repositoryService;

    @Autowired
    private RuntimeService runtimeService;

    public FlowsInfo updateCandidate(String flowKey, List<String> candidateUsers , List<CandidateRoleDetailVo> candidateRoleDetailVo ){
        FlowsInfo flowsInfo = flowsInfoMapper.findByFlowKey(flowKey);
        flowsInfo.setCandidateUser(candidateUsers);
        flowsInfo.setCandidateGroup(candidateRoleDetailVo);
        FlowsInfo newFlowsInfo = flowsInfoMapper.save(flowsInfo);
        return newFlowsInfo;
    }

    @Override
    public FlowsInfo findById(Integer id) {
        return flowsInfoMapper.findById(id).get();
    }

    @Override
    public FlowsInfo updateByProcessName( FlowsInfoVo flowsInfoVo) {
        String flowKey = flowsInfoVo.getFlowKey();
        String flowName = flowsInfoVo.getFlowName();
        FlowsInfo flowsInfo = flowsInfoMapper.findByFlowKey(flowKey);
        flowsInfo.setFlowName(flowName);
        //进行更新
        FlowsInfo newFlowsInfo = flowsInfoMapper.save(flowsInfo);
        return newFlowsInfo;
    }

    @Override
    public FlowsInfo findByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {

        String flowKey = flowsInfoVo.getFlowKey();
        String describe = flowsInfoVo.getFlowDescribe();
        FlowsInfo byDesc = flowsInfoMapper.findByFlowKey(flowKey);
        byDesc.setFlowDescribe(describe);
//        //进行更新
        return flowsInfoMapper.save(byDesc);
    }

    @Override
    public FlowsInfo findByDeployId(String deployId) {
        return flowsInfoMapper.findByDeployId(deployId);
    }


    @Override
    public FlowsInfo findByFlowKey(String flowKey) {
        return flowsInfoMapper.findByFlowKey(flowKey);
    }

    @Override
    public FlowsInfo disableFlow(Integer flowInfoId) {
        Optional<FlowsInfo> byId = flowsInfoMapper.findById(flowInfoId);
        if (byId.isPresent()){
            FlowsInfo flowsInfo = byId.get();
            flowsInfo.setState(1);
            flowsInfoMapper.save(flowsInfo);
        }else {
            throw new ApiException("要禁用的流程不存在");
        }
        return null;
    }

    @Override
    public Page<FlowsInfo> searchAllFlowInfo(SearchAllFlowInfoVo searchAllFlowInfoVo) {
        PredicateBuilder<FlowsInfo> and = Specifications.and();
        and.eq(searchAllFlowInfoVo.getState()!=null,"state",searchAllFlowInfoVo.getState());
        and.eq(searchAllFlowInfoVo.getFlowKey()!=null,"flowKey",searchAllFlowInfoVo.getFlowKey());
        and.like(searchAllFlowInfoVo.getFlowName()!=null,"flowName","%"+searchAllFlowInfoVo.getFlowName()+"%");
        return flowsInfoMapper.findAll(and.build(), searchAllFlowInfoVo.getPageable());
    }

    @Override
    public Page<FlowsInfo> searchFlowInfo(SearchFlowInfoVo searchFlowInfoVo) {
        PredicateBuilder<FlowsInfo> and = Specifications.and();
        and.eq(searchFlowInfoVo.getState()!=null,"state",searchFlowInfoVo.getState());
        and.eq(!StringUtils.isEmpty(searchFlowInfoVo.getFlowKey()),"flowKey",searchFlowInfoVo.getFlowKey());
        and.like(!StringUtils.isEmpty(searchFlowInfoVo.getFlowName()),"flowName","%"+searchFlowInfoVo.getFlowName()+"%");
        PredicateBuilder<FlowsInfo> userOr = Specifications.or();
        userOr.like(!StringUtils.isEmpty(searchFlowInfoVo.getUserId()),"candidateUser","%"+searchFlowInfoVo.getUserId()+",%");
        List<String> roleStrings = searchFlowInfoVo.getRoleStrings();
        for (String roleString : roleStrings) {
            userOr.like("CandidateGroup","%"+roleString+",%");
        }
        return flowsInfoMapper.findAll(and.build().and(userOr.build()), searchFlowInfoVo.getPageable());
    }

    /**
     * 根据ID查询流程详情
     * @param id 流程id
     * @return
     */
    @Override
    public FlowsInfo editFlow(Integer id) {
        return flowsInfoMapper.findById(id).get();
    }



}
