package com.tykj.workflowcore.model.controller;

import com.tykj.workflowcore.base.result.ResultObj;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.model.entity.TableInfo;
import com.tykj.workflowcore.model.service.TableInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "基础模型接口")
@CrossOrigin
@RequestMapping("/tableinfo")
@RestController
public class TableInfoController {

    @Autowired
    private TableInfoService tableInfoService;

    @ApiOperation(value = "新增基础模型")
    @PostMapping
    public ResponseEntity save(@RequestBody TableInfo tableInfo){
        tableInfoService.save(tableInfo);
        return ResponseEntity.ok("新增成功");
    }

    @ApiOperation(value = "修改基础模型")
    @PutMapping
    public ResponseEntity update(@RequestBody TableInfo tableInfo){
        tableInfoService.update(tableInfo);
        return ResponseEntity.ok("修改成功");
    }

    @ApiOperation(value = "查询所有基础模型")
    @GetMapping
    public ResponseEntity<List<TableInfo>> findAll(){
        List<TableInfo> tableInfos = tableInfoService.findAll();
        return ResponseEntity.ok(tableInfos);
    }

}
