package com.tykj.workflowcore.model.controller;

import com.tykj.workflowcore.model.entity.TableInfoEx;
import com.tykj.workflowcore.model.service.TableInfoExService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "聚合模型接口")
@CrossOrigin
@RequestMapping("/tableinfoex")
@RestController
public class TableInfoExController {

    @Autowired
    private TableInfoExService tableInfoExService;

    @ApiOperation(value = "新增聚合模型")
    @PostMapping
    public ResponseEntity save(@RequestBody TableInfoEx tableInfoEx){
        tableInfoExService.save(tableInfoEx);
        return ResponseEntity.ok("新增成功");
    }

    @ApiOperation(value = "修改聚合模型")
    @PutMapping
    public ResponseEntity update(@RequestBody TableInfoEx tableInfoEx){
        tableInfoExService.update(tableInfoEx);
        return ResponseEntity.ok("修改成功");
    }

    @ApiOperation(value = "查询所有聚合模型")
    @GetMapping
    public ResponseEntity<List<TableInfoEx>> findAll(){
        List<TableInfoEx> tableInfos = tableInfoExService.findAll();
        return ResponseEntity.ok(tableInfos);
    }

}
